/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.liteminer.shapes;

import java.util.ArrayList;
import java.util.List;

public class Cycler<T> {
    private final List<T> items;
    private int currentIndex;

    public Cycler(List<T> initialItems) {
        if (initialItems == null || initialItems.isEmpty()) {
            throw new IllegalArgumentException("Item list cannot be null or empty");
        }
        this.items = new ArrayList<T>(initialItems);
        this.currentIndex = 0;
    }

    public T getCurrentItem() {
        return this.items.get(this.currentIndex);
    }

    public T nextItem() {
        this.currentIndex = (this.currentIndex + 1) % this.items.size();
        return this.getCurrentItem();
    }

    public T previousItem() {
        this.currentIndex = (this.currentIndex - 1 + this.items.size()) % this.items.size();
        return this.getCurrentItem();
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }
}

