/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.liteminer.shapes;

import com.iamkaf.liteminer.Liteminer;
import com.iamkaf.liteminer.shapes.Walker;
import com.iamkaf.liteminer.tags.TagHelper;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TunnelWalker
implements Walker {
    public final Set<BlockPos> VISITED = new HashSet<BlockPos>();

    @NotNull
    public static BlockHitResult raytrace(Level level, Player player) {
        Vec3 eyePosition = player.getEyePosition();
        Vec3 rotation = player.getViewVector(1.0f);
        double reach = player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
        Vec3 combined = eyePosition.add(rotation.x * reach, rotation.y * reach, rotation.z * reach);
        return level.clip(new ClipContext(eyePosition, combined, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
    }

    public String toString() {
        return "Small Tunnel";
    }

    @Override
    public HashSet<BlockPos> walk(Level level, Player player, BlockPos origin) {
        Direction direction = TunnelWalker.raytrace(level, player).getDirection().getOpposite();
        HashSet<BlockPos> potentialBrokenBlocks = new HashSet<BlockPos>();
        potentialBrokenBlocks.add(origin);
        BlockState originState = level.getBlockState(origin);
        if (originState.is(Blocks.AIR)) {
            return new HashSet<BlockPos>(0);
        }
        if (TagHelper.isExcludedBlock(originState)) {
            return potentialBrokenBlocks;
        }
        this.searchBlocks(player, level, origin, origin, potentialBrokenBlocks, originState.getBlock(), direction);
        this.VISITED.clear();
        return potentialBrokenBlocks;
    }

    private void searchBlocks(Player player, Level level, BlockPos myPos, BlockPos absoluteOrigin, HashSet<BlockPos> blocksToCollapse, Block originBlock, Direction direction) {
        boolean shouldMineCursor;
        if (this.VISITED.size() >= (Integer)Liteminer.CONFIG.blockBreakLimit.get()) {
            return;
        }
        if (this.VISITED.contains(myPos)) {
            return;
        }
        BlockState state = level.getBlockState(myPos);
        if (state.is(Blocks.AIR) || TagHelper.isExcludedBlock(state)) {
            return;
        }
        BlockPos cursor = myPos;
        while (blocksToCollapse.size() < (Integer)Liteminer.CONFIG.blockBreakLimit.get() && (shouldMineCursor = this.shouldMine(player, level, cursor))) {
            blocksToCollapse.add(cursor);
            cursor = cursor.relative(direction);
        }
        blocksToCollapse.add(myPos);
    }
}

