/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.liteminer.shapes;

import com.iamkaf.liteminer.Liteminer;
import com.iamkaf.liteminer.shapes.BlockFamily;
import com.iamkaf.liteminer.shapes.Walker;
import com.iamkaf.liteminer.tags.TagHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;

public class ShapelessWalker
implements Walker {
    public final Set<class_2338> VISITED = new HashSet<class_2338>();
    public final int RANGE = 64;

    @NotNull
    public static class_3965 raytrace(class_1937 level, class_1657 player) {
        class_243 eyePosition = player.method_33571();
        class_243 rotation = player.method_5828(1.0f);
        double reach = player.method_45325(class_5134.field_47758);
        class_243 combined = eyePosition.method_1031(rotation.field_1352 * reach, rotation.field_1351 * reach, rotation.field_1350 * reach);
        return level.method_17742(new class_3959(eyePosition, combined, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player));
    }

    public String toString() {
        return "Shapeless";
    }

    @NotNull
    public static class_2338 raytraceBlock(class_1937 level, class_1657 player) {
        class_3965 rayTraceResult = ShapelessWalker.raytrace(level, player);
        class_2350 direction = rayTraceResult.method_17780();
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033, class_2350.field_11043, class_2350.field_11039 -> rayTraceResult.method_17777();
            case class_2350.field_11036 -> rayTraceResult.method_17777().method_10074();
            case class_2350.field_11035 -> rayTraceResult.method_17777().method_10095();
            case class_2350.field_11034 -> rayTraceResult.method_17777().method_10067();
        };
    }

    @Override
    public HashSet<class_2338> walk(class_1937 level, class_1657 player, class_2338 origin) {
        HashSet<class_2338> potentialBrokenBlocks = new HashSet<class_2338>();
        potentialBrokenBlocks.add(origin);
        class_2680 originState = level.method_8320(origin);
        if (originState.method_27852(class_2246.field_10124)) {
            return new HashSet<class_2338>(0);
        }
        if (TagHelper.isExcludedBlock(originState)) {
            return potentialBrokenBlocks;
        }
        this.searchBlocks(player, level, origin, origin, potentialBrokenBlocks, originState.method_26204());
        this.VISITED.clear();
        return potentialBrokenBlocks;
    }

    private void searchBlocks(class_1657 player, class_1937 level, class_2338 myPos, class_2338 absoluteOrigin, HashSet<class_2338> blocksToCollapse, class_2248 originBlock) {
        if (this.VISITED.size() >= (Integer)Liteminer.CONFIG.blockBreakLimit.get()) {
            return;
        }
        if (this.VISITED.contains(myPos)) {
            return;
        }
        if (!BlockFamily.matches(originBlock, level.method_8320(myPos).method_26204())) {
            return;
        }
        if (!this.shouldMine(player, level, myPos)) {
            return;
        }
        blocksToCollapse.add(myPos);
        this.VISITED.add(myPos);
        for (class_2338 neighborPos : this.getNeighbors(myPos, absoluteOrigin)) {
            this.searchBlocks(player, level, neighborPos, absoluteOrigin, blocksToCollapse, originBlock);
        }
    }

    private List<class_2338> getNeighbors(class_2338 myPos, class_2338 absoluteOrigin) {
        ArrayList<class_2338> blocks = new ArrayList<class_2338>();
        blocks.add(myPos.method_10084());
        blocks.add(myPos.method_10074());
        blocks.add(myPos.method_10095());
        blocks.add(myPos.method_10072());
        blocks.add(myPos.method_10078());
        blocks.add(myPos.method_10067());
        blocks.add(myPos.method_10095().method_10078());
        blocks.add(myPos.method_10095().method_10067());
        blocks.add(myPos.method_10072().method_10078());
        blocks.add(myPos.method_10072().method_10067());
        blocks.add(myPos.method_10084().method_10095());
        blocks.add(myPos.method_10084().method_10072());
        blocks.add(myPos.method_10084().method_10078());
        blocks.add(myPos.method_10084().method_10067());
        blocks.add(myPos.method_10084().method_10095().method_10078());
        blocks.add(myPos.method_10084().method_10095().method_10067());
        blocks.add(myPos.method_10084().method_10072().method_10078());
        blocks.add(myPos.method_10084().method_10072().method_10067());
        blocks.add(myPos.method_10074().method_10095());
        blocks.add(myPos.method_10074().method_10072());
        blocks.add(myPos.method_10074().method_10078());
        blocks.add(myPos.method_10074().method_10067());
        blocks.add(myPos.method_10074().method_10095().method_10078());
        blocks.add(myPos.method_10074().method_10095().method_10067());
        blocks.add(myPos.method_10074().method_10072().method_10078());
        blocks.add(myPos.method_10074().method_10072().method_10067());
        blocks.sort(Comparator.comparingInt(p -> p.method_19455((class_2382)absoluteOrigin)));
        return blocks;
    }
}

