/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.liteminer.rendering;

import com.iamkaf.amber.api.player.FeedbackHelper;
import com.iamkaf.liteminer.LiteminerClient;
import com.iamkaf.liteminer.networking.C2SVeinmineKeybindChange;
import com.iamkaf.liteminer.networking.LiteminerNetwork;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import org.joml.Matrix3x2fStack;

public class HUD {
    public static void onRenderHUD(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!((Boolean)LiteminerClient.CONFIG.showHUD.get()).booleanValue()) {
            return;
        }
        if (Minecraft.getInstance().options.hideGui) {
            return;
        }
        int selectedBlockCount = LiteminerClient.selectedBlocks.size();
        if (selectedBlockCount == 0) {
            return;
        }
        if (!LiteminerClient.isVeinMining() || !LiteminerClient.isTargetingABlock()) {
            return;
        }
        Font font = Minecraft.getInstance().font;
        int lineHeight = 10;
        float scale = ((Double)LiteminerClient.CONFIG.hud_scale.get()).floatValue();
        int width = guiGraphics.guiWidth();
        int height = guiGraphics.guiHeight();
        int centerWidth = (int)((float)width / 2.0f / scale);
        int centerHeight = (int)((float)height / 2.0f / scale);
        int xOffset = (int)(5.0f / scale);
        int yOffset = (int)(-10.0f / scale);
        MutableComponent selectedBlocksLabel = Component.translatable((String)(selectedBlockCount > 1 ? "hud.liteminer.selected_blocks" : "hud.liteminer.selected_blocks_singular"), (Object[])new Object[]{selectedBlockCount});
        Matrix3x2fStack pose = guiGraphics.pose();
        pose.pushMatrix();
        pose.scale(scale, scale);
        guiGraphics.drawString(font, (Component)selectedBlocksLabel, centerWidth + xOffset, centerHeight + yOffset, -1);
        guiGraphics.drawString(font, LiteminerClient.shapes.getCurrentItem().toString(), centerWidth + xOffset, centerHeight + yOffset + lineHeight, -1);
        pose.popMatrix();
    }

    public static InteractionResult onMouseScroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (LiteminerClient.isVeinMining()) {
            Minecraft minecraft = Minecraft.getInstance();
            if (scrollY != 0.0) {
                if (scrollY > 0.0) {
                    LiteminerClient.shapes.previousItem();
                } else if (scrollY < 0.0) {
                    LiteminerClient.shapes.nextItem();
                }
                LiteminerNetwork.sendToServer(new C2SVeinmineKeybindChange(LiteminerClient.isVeinMining(), LiteminerClient.shapes.getCurrentIndex()));
            }
            if (!((Boolean)LiteminerClient.CONFIG.showHUD.get()).booleanValue()) {
                assert (minecraft.player != null);
                FeedbackHelper.actionBarMessage((Player)minecraft.player, (Component)Component.translatable((String)"hud.liteminer.changed_shape", (Object[])new Object[]{LiteminerClient.shapes.getCurrentItem().toString()}));
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }
}

