/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.liteminer.shapes;

import com.iamkaf.liteminer.Liteminer;
import com.iamkaf.liteminer.shapes.BlockFamily;
import com.iamkaf.liteminer.shapes.Walker;
import com.iamkaf.liteminer.tags.TagHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ShapelessWalker
implements Walker {
    public final Set<BlockPos> VISITED = new HashSet<BlockPos>();
    public final int RANGE = 64;

    @NotNull
    public static BlockHitResult raytrace(Level level, Player player) {
        Vec3 eyePosition = player.getEyePosition();
        Vec3 rotation = player.getViewVector(1.0f);
        double reach = player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
        Vec3 combined = eyePosition.add(rotation.x * reach, rotation.y * reach, rotation.z * reach);
        return level.clip(new ClipContext(eyePosition, combined, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
    }

    public String toString() {
        return "Shapeless";
    }

    @NotNull
    public static BlockPos raytraceBlock(Level level, Player player) {
        BlockHitResult rayTraceResult = ShapelessWalker.raytrace(level, player);
        Direction direction = rayTraceResult.getDirection();
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN, Direction.NORTH, Direction.WEST -> rayTraceResult.getBlockPos();
            case Direction.UP -> rayTraceResult.getBlockPos().below();
            case Direction.SOUTH -> rayTraceResult.getBlockPos().north();
            case Direction.EAST -> rayTraceResult.getBlockPos().west();
        };
    }

    @Override
    public HashSet<BlockPos> walk(Level level, Player player, BlockPos origin) {
        HashSet<BlockPos> potentialBrokenBlocks = new HashSet<BlockPos>();
        potentialBrokenBlocks.add(origin);
        BlockState originState = level.getBlockState(origin);
        if (originState.is(Blocks.AIR)) {
            return new HashSet<BlockPos>(0);
        }
        if (TagHelper.isExcludedBlock(originState)) {
            return potentialBrokenBlocks;
        }
        this.searchBlocks(player, level, origin, origin, potentialBrokenBlocks, originState.getBlock());
        this.VISITED.clear();
        return potentialBrokenBlocks;
    }

    private void searchBlocks(Player player, Level level, BlockPos myPos, BlockPos absoluteOrigin, HashSet<BlockPos> blocksToCollapse, Block originBlock) {
        if (this.VISITED.size() >= (Integer)Liteminer.CONFIG.blockBreakLimit.get()) {
            return;
        }
        if (this.VISITED.contains(myPos)) {
            return;
        }
        if (!BlockFamily.matches(originBlock, level.getBlockState(myPos).getBlock())) {
            return;
        }
        if (!this.shouldMine(player, level, myPos)) {
            return;
        }
        blocksToCollapse.add(myPos);
        this.VISITED.add(myPos);
        for (BlockPos neighborPos : this.getNeighbors(myPos, absoluteOrigin)) {
            this.searchBlocks(player, level, neighborPos, absoluteOrigin, blocksToCollapse, originBlock);
        }
    }

    private List<BlockPos> getNeighbors(BlockPos myPos, BlockPos absoluteOrigin) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        blocks.add(myPos.above());
        blocks.add(myPos.below());
        blocks.add(myPos.north());
        blocks.add(myPos.south());
        blocks.add(myPos.east());
        blocks.add(myPos.west());
        blocks.add(myPos.north().east());
        blocks.add(myPos.north().west());
        blocks.add(myPos.south().east());
        blocks.add(myPos.south().west());
        blocks.add(myPos.above().north());
        blocks.add(myPos.above().south());
        blocks.add(myPos.above().east());
        blocks.add(myPos.above().west());
        blocks.add(myPos.above().north().east());
        blocks.add(myPos.above().north().west());
        blocks.add(myPos.above().south().east());
        blocks.add(myPos.above().south().west());
        blocks.add(myPos.below().north());
        blocks.add(myPos.below().south());
        blocks.add(myPos.below().east());
        blocks.add(myPos.below().west());
        blocks.add(myPos.below().north().east());
        blocks.add(myPos.below().north().west());
        blocks.add(myPos.below().south().east());
        blocks.add(myPos.below().south().west());
        blocks.sort(Comparator.comparingInt(p -> p.distManhattan((Vec3i)absoluteOrigin)));
        return blocks;
    }
}

