/*
 * Decompiled with CFR 0.152.
 */
package com.gensproy;

import com.gensproy.Generator;
import com.gensproy.GensProY;
import com.gensproy.MessagesManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class GeneratorManager {
    private final GensProY plugin;
    private final Map<String, Generator> generators = new HashMap<String, Generator>();
    private final Map<UUID, Integer> playerGensCount = new HashMap<UUID, Integer>();

    public GeneratorManager(GensProY plugin) {
        this.plugin = plugin;
        this.loadGenerators();
    }

    public void loadGenerators() {
        FileConfiguration config = this.plugin.getConfig();
        if (!config.contains("generators")) {
            this.plugin.getLogger().info("No generators found in config - starting fresh");
            return;
        }
        ConfigurationSection section = config.getConfigurationSection("generators");
        int loadedCount = 0;
        int failedCount = 0;
        for (String key : section.getKeys(false)) {
            ConfigurationSection genSection = section.getConfigurationSection(key);
            String world = genSection.getString("world");
            int x = genSection.getInt("x");
            int y = genSection.getInt("y");
            int z = genSection.getInt("z");
            int level = genSection.getInt("level");
            UUID owner = UUID.fromString(genSection.getString("owner"));
            boolean isGemGenerator = genSection.getBoolean("isGemGenerator", false);
            if (this.plugin.getServer().getWorld(world) == null) {
                this.plugin.getLogger().warning(this.plugin.getMessagesManager().getConsoleMessage("console-invalid-world", MessagesManager.builder().add("world", world).add("x", x).add("y", y).add("z", z).build()));
                ++failedCount;
                continue;
            }
            Location loc = new Location(this.plugin.getServer().getWorld(world), (double)x, (double)y, (double)z);
            Generator gen = new Generator(loc, level, owner, isGemGenerator);
            this.generators.put(this.locationToString(loc), gen);
            this.playerGensCount.put(owner, this.playerGensCount.getOrDefault(owner, 0) + 1);
            this.updateGeneratorAppearance(loc, level, gen.isGemGenerator());
            ++loadedCount;
        }
        this.plugin.getLogger().info(this.plugin.getMessagesManager().getConsoleMessage("console-generators-loaded", MessagesManager.placeholder("count", String.valueOf(loadedCount))));
        if (failedCount > 0) {
            this.plugin.getLogger().warning("Failed to load " + failedCount + " generators (invalid worlds)");
        }
    }

    public void saveGenerators() {
        try {
            FileConfiguration config = this.plugin.getConfig();
            if (config.contains("generators")) {
                config.set("generators", null);
            }
            ConfigurationSection generatorsSection = config.createSection("generators");
            int index = 0;
            for (Map.Entry<String, Generator> entry : this.generators.entrySet()) {
                Generator gen = entry.getValue();
                ConfigurationSection genSection = generatorsSection.createSection(String.valueOf(index));
                genSection.set("world", (Object)gen.getLocation().getWorld().getName());
                genSection.set("x", (Object)gen.getLocation().getBlockX());
                genSection.set("y", (Object)gen.getLocation().getBlockY());
                genSection.set("z", (Object)gen.getLocation().getBlockZ());
                genSection.set("level", (Object)gen.getLevel());
                genSection.set("owner", (Object)gen.getOwner().toString());
                genSection.set("isGemGenerator", (Object)gen.isGemGenerator());
                ++index;
            }
            this.plugin.saveConfig();
            this.plugin.getLogger().info(this.plugin.getMessagesManager().getConsoleMessage("console-generators-saved", MessagesManager.placeholder("count", String.valueOf(this.generators.size()))));
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to save generators: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void forceSave() {
        this.saveGenerators();
    }

    public boolean isGenerator(Location loc) {
        return this.generators.containsKey(this.locationToString(loc));
    }

    public Generator getGenerator(Location loc) {
        return this.generators.get(this.locationToString(loc));
    }

    public void addGenerator(Location loc, Generator gen) {
        this.generators.put(this.locationToString(loc), gen);
        this.playerGensCount.put(gen.getOwner(), this.playerGensCount.getOrDefault(gen.getOwner(), 0) + 1);
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, this::saveGenerators);
    }

    public void removeGenerator(Location loc) {
        String key = this.locationToString(loc);
        if (this.generators.containsKey(key)) {
            Generator gen = this.generators.get(key);
            this.playerGensCount.put(gen.getOwner(), Math.max(0, this.playerGensCount.getOrDefault(gen.getOwner(), 0) - 1));
            this.generators.remove(key);
            this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, this::saveGenerators);
        }
    }

    public int getPlayerGeneratorCount(UUID playerId) {
        return this.playerGensCount.getOrDefault(playerId, 0);
    }

    private String locationToString(Location loc) {
        return loc.getWorld().getName() + "," + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
    }

    private void updateGeneratorAppearance(Location loc, int level, boolean isGemGenerator) {
        Material blockType;
        Block block = loc.getBlock();
        if (isGemGenerator) {
            switch (level) {
                case 1: {
                    blockType = Material.AMETHYST_BLOCK;
                    break;
                }
                case 2: {
                    blockType = Material.PRISMARINE;
                    break;
                }
                case 3: {
                    blockType = Material.SEA_LANTERN;
                    break;
                }
                case 4: {
                    blockType = Material.END_STONE_BRICKS;
                    break;
                }
                case 5: {
                    blockType = Material.PURPUR_BLOCK;
                    break;
                }
                default: {
                    blockType = Material.AMETHYST_BLOCK;
                    break;
                }
            }
        } else {
            String blockTypeStr = this.plugin.getConfig().getString("generator-decorations.level-" + level + ".block-type");
            if (blockTypeStr != null) {
                try {
                    blockType = Material.valueOf((String)blockTypeStr.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning(this.plugin.getMessagesManager().getConsoleMessage("console-invalid-block-type", MessagesManager.builder().add("type", blockTypeStr).add("level", level).build()));
                    blockType = this.getDefaultBlockType(level);
                }
            } else {
                blockType = this.getDefaultBlockType(level);
            }
        }
        block.setType(blockType);
    }

    private Material getDefaultBlockType(int level) {
        switch (level) {
            case 16: {
                return Material.IRON_BLOCK;
            }
            case 17: {
                return Material.COAL_BLOCK;
            }
            case 18: {
                return Material.DIAMOND_BLOCK;
            }
            case 19: {
                return Material.EMERALD_BLOCK;
            }
            case 20: {
                return Material.NETHERITE_BLOCK;
            }
        }
        Material[] basicBlocks = new Material[]{Material.WHITE_STAINED_GLASS, Material.YELLOW_STAINED_GLASS, Material.ORANGE_STAINED_GLASS, Material.RED_STAINED_GLASS, Material.MAGENTA_STAINED_GLASS, Material.PURPLE_STAINED_GLASS, Material.BLUE_STAINED_GLASS, Material.CYAN_STAINED_GLASS, Material.LIME_STAINED_GLASS, Material.GREEN_STAINED_GLASS, Material.BROWN_STAINED_GLASS, Material.BLACK_STAINED_GLASS, Material.LIGHT_BLUE_STAINED_GLASS, Material.LIGHT_GRAY_STAINED_GLASS, Material.GRAY_STAINED_GLASS};
        if (level <= 15) {
            return basicBlocks[(level - 1) % basicBlocks.length];
        }
        return Material.WHITE_STAINED_GLASS;
    }

    public Map<Location, Generator> getPlayerGenerators(UUID playerId) {
        HashMap<Location, Generator> playerGens = new HashMap<Location, Generator>();
        for (Map.Entry<String, Generator> entry : this.generators.entrySet()) {
            Generator gen = entry.getValue();
            if (!gen.getOwner().equals(playerId)) continue;
            playerGens.put(gen.getLocation(), gen);
        }
        return playerGens;
    }

    public int getTotalGeneratorCount() {
        return this.generators.size();
    }

    public Collection<Generator> getAllGenerators() {
        return new ArrayList<Generator>(this.generators.values());
    }
}

