/*
 * Decompiled with CFR 0.152.
 */
package com.gensproy;

import com.gensproy.Generator;
import com.gensproy.GeneratorManager;
import com.gensproy.MessagesManager;
import com.gensproy.PlaceholderManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class GensProY
extends JavaPlugin
implements Listener {
    private FileConfiguration config;
    private GeneratorManager generatorManager;
    private PlaceholderManager placeholderManager;
    private MessagesManager messagesManager;
    private Random random = new Random();
    private Economy economy = null;
    private final Map<UUID, Long> upgradeCooldowns = new HashMap<UUID, Long>();
    private static final long UPGRADE_COOLDOWN_MS = 500L;
    private final Map<String, BukkitTask> generatorTasks = new HashMap<String, BukkitTask>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.messagesManager = new MessagesManager(this);
        if (!this.setupEconomy()) {
            this.getLogger().severe(this.messagesManager.getConsoleMessage("console-vault-not-found"));
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.generatorManager = new GeneratorManager(this);
        this.placeholderManager = new PlaceholderManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("gengive").setExecutor((CommandExecutor)this);
        this.getCommand("gemgengive").setExecutor((CommandExecutor)this);
        this.getCommand("genslots").setExecutor((CommandExecutor)this);
        this.getCommand("genstats").setExecutor((CommandExecutor)this);
        this.getCommand("genreload").setExecutor((CommandExecutor)this);
        this.restartAllGenerators();
        this.startAutoSaveTask();
        this.getLogger().info(this.messagesManager.getConsoleMessage("console-enabled"));
    }

    private void restartAllGenerators() {
        this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
            Collection<Generator> allGens = this.generatorManager.getAllGenerators();
            int startedCount = 0;
            for (Generator gen : allGens) {
                boolean requireOwnerOnline = this.config.getBoolean("require-owner-online", true);
                if (requireOwnerOnline && !this.isOwnerOnline(gen.getOwner())) continue;
                this.startGeneratorTask(gen);
                ++startedCount;
            }
            this.getLogger().info(this.messagesManager.getConsoleMessage("console-generators-restarted", MessagesManager.builder().add("started", startedCount).add("total", allGens.size()).build()));
        }, 40L);
    }

    private boolean isOwnerOnline(UUID ownerId) {
        Player owner = this.getServer().getPlayer(ownerId);
        return owner != null && owner.isOnline();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        boolean requireOwnerOnline = this.config.getBoolean("require-owner-online", true);
        if (requireOwnerOnline) {
            Map<Location, Generator> playerGens = this.generatorManager.getPlayerGenerators(player.getUniqueId());
            this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
                int startedCount = 0;
                for (Generator gen : playerGens.values()) {
                    String key = this.locationToString(gen.getLocation());
                    if (this.generatorTasks.containsKey(key) && !this.generatorTasks.get(key).isCancelled()) continue;
                    this.startGeneratorTask(gen);
                    ++startedCount;
                }
                if (startedCount > 0) {
                    this.getLogger().info(this.messagesManager.getConsoleMessage("console-generators-started-player", MessagesManager.builder().add("count", startedCount).add("player", player.getName()).build()));
                }
            }, 20L);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        boolean requireOwnerOnline = this.config.getBoolean("require-owner-online", true);
        if (requireOwnerOnline) {
            Map<Location, Generator> playerGens = this.generatorManager.getPlayerGenerators(player.getUniqueId());
            int stoppedCount = 0;
            for (Generator gen : playerGens.values()) {
                String key = this.locationToString(gen.getLocation());
                BukkitTask task = this.generatorTasks.get(key);
                if (task == null || task.isCancelled()) continue;
                task.cancel();
                this.generatorTasks.remove(key);
                ++stoppedCount;
            }
            if (stoppedCount > 0) {
                this.getLogger().info(this.messagesManager.getConsoleMessage("console-generators-stopped-player", MessagesManager.builder().add("count", stoppedCount).add("player", player.getName()).build()));
            }
        }
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return this.economy != null;
    }

    public void onDisable() {
        for (BukkitTask task : this.generatorTasks.values()) {
            if (task == null || task.isCancelled()) continue;
            task.cancel();
        }
        this.generatorTasks.clear();
        this.generatorManager.saveGenerators();
        this.upgradeCooldowns.clear();
        this.getLogger().info(this.messagesManager.getConsoleMessage("console-disabled"));
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("gengive")) {
            return this.handleGenGiveCommand(sender, args, false);
        }
        if (cmd.getName().equalsIgnoreCase("gemgengive")) {
            return this.handleGenGiveCommand(sender, args, true);
        }
        if (cmd.getName().equalsIgnoreCase("genstats")) {
            return this.handleGenStatsCommand(sender, args);
        }
        if (cmd.getName().equalsIgnoreCase("genslots")) {
            int amount;
            if (!sender.hasPermission("gensproy.admin")) {
                this.messagesManager.sendMessage(sender, "no-permission");
                return true;
            }
            if (args.length != 2) {
                this.messagesManager.sendMessage(sender, "genslots-usage");
                return true;
            }
            Player target = this.getServer().getPlayer(args[0]);
            if (target == null) {
                this.messagesManager.sendMessage(sender, "player-not-found", MessagesManager.placeholder("player", args[0]));
                return true;
            }
            try {
                amount = Integer.parseInt(args[1]);
                if (amount < 1) {
                    int maxExtraSlots = this.config.getInt("max-extra-slots", 64);
                    this.messagesManager.sendMessage(sender, "genslots-invalid-amount", MessagesManager.placeholder("max", String.valueOf(maxExtraSlots)));
                    return true;
                }
            }
            catch (NumberFormatException e) {
                this.messagesManager.sendMessage(sender, "invalid-number");
                return true;
            }
            int currentExtraSlots = this.config.getInt("players." + String.valueOf(target.getUniqueId()) + ".extra-slots", 0);
            int newTotalSlots = currentExtraSlots + amount;
            int maxExtraSlots = this.config.getInt("max-extra-slots", 64);
            if (newTotalSlots > maxExtraSlots) {
                this.messagesManager.sendMessage(sender, "genslots-invalid-amount", MessagesManager.placeholder("max", String.valueOf(maxExtraSlots)));
                return true;
            }
            int baseLimit = this.config.getInt("base-generator-limit", 4);
            int extraFromPermissions = this.getExtraGenSlotsFromPermissions(target);
            int newLimit = baseLimit + extraFromPermissions + newTotalSlots;
            this.config.set("players." + String.valueOf(target.getUniqueId()) + ".extra-slots", (Object)newTotalSlots);
            this.saveConfig();
            Map<String, String> placeholders = MessagesManager.builder().add("amount", amount).add("player", target.getName()).add("slots", newTotalSlots).build();
            this.messagesManager.sendMessage(sender, "genslots-success", placeholders);
            placeholders.put("limit", String.valueOf(newLimit));
            this.messagesManager.sendMessage((CommandSender)target, "genslots-notify-target", placeholders);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("genreload")) {
            if (!sender.hasPermission("gensproy.admin")) {
                this.messagesManager.sendMessage(sender, "no-permission");
                return true;
            }
            try {
                for (BukkitTask task : this.generatorTasks.values()) {
                    if (task == null || task.isCancelled()) continue;
                    task.cancel();
                }
                this.generatorTasks.clear();
                this.reloadConfig();
                this.config = this.getConfig();
                this.messagesManager.reloadMessages();
                this.restartAllGenerators();
                this.messagesManager.sendMessage(sender, "reload-success");
            }
            catch (Exception e) {
                this.messagesManager.sendMessage(sender, "reload-failed");
                this.getLogger().severe("Error during reload: " + e.getMessage());
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private boolean handleGenGiveCommand(CommandSender sender, String[] args, boolean isGemGenerator) {
        int maxLevel;
        int amount;
        int level;
        Player targetPlayer;
        block27: {
            String usageKey;
            String commandName = isGemGenerator ? "gemgengive" : "gengive";
            String string = usageKey = isGemGenerator ? "gemgengive-usage" : "gengive-usage";
            if (args.length < 1 || args.length > 3) {
                this.messagesManager.sendMessage(sender, usageKey);
                return true;
            }
            targetPlayer = null;
            level = 1;
            amount = 1;
            if (args.length == 1) {
                if (!(sender instanceof Player)) {
                    this.messagesManager.sendMessage(sender, "must-be-player");
                    return true;
                }
                targetPlayer = (Player)sender;
                try {
                    level = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException e) {
                    this.messagesManager.sendMessage(sender, "invalid-number");
                    return true;
                }
            }
            if (args.length >= 2) {
                try {
                    level = Integer.parseInt(args[0]);
                    targetPlayer = this.getServer().getPlayer(args[1]);
                    if (targetPlayer == null) {
                        this.messagesManager.sendMessage(sender, "player-not-found", MessagesManager.placeholder("player", args[1]));
                        return true;
                    }
                    if (args.length != 3) break block27;
                    try {
                        amount = Integer.parseInt(args[2]);
                    }
                    catch (NumberFormatException e) {
                        this.messagesManager.sendMessage(sender, "invalid-number");
                        return true;
                    }
                }
                catch (NumberFormatException e) {
                    targetPlayer = this.getServer().getPlayer(args[0]);
                    if (targetPlayer == null) {
                        this.messagesManager.sendMessage(sender, "player-not-found", MessagesManager.placeholder("player", args[0]));
                        return true;
                    }
                    try {
                        level = Integer.parseInt(args[1]);
                    }
                    catch (NumberFormatException e2) {
                        this.messagesManager.sendMessage(sender, "invalid-number");
                        return true;
                    }
                    if (args.length != 3) break block27;
                    try {
                        amount = Integer.parseInt(args[2]);
                    }
                    catch (NumberFormatException e3) {
                        this.messagesManager.sendMessage(sender, "invalid-number");
                        return true;
                    }
                }
            }
        }
        int n = maxLevel = isGemGenerator ? this.config.getInt("max-gem-generator-level", 5) : this.config.getInt("max-generator-level", 20);
        if (level < 1 || level > maxLevel) {
            String invalidLevelKey = isGemGenerator ? "gemgengive-invalid-level" : "gengive-invalid-level";
            this.messagesManager.sendMessage(sender, invalidLevelKey, MessagesManager.placeholder("max", String.valueOf(maxLevel)));
            return true;
        }
        if (amount < 1 || amount > 64) {
            this.messagesManager.sendMessage(sender, "invalid-number");
            return true;
        }
        if (sender instanceof Player) {
            String permission;
            Player player = (Player)sender;
            String string = permission = isGemGenerator ? "gensproy.gemgengive" : "gensproy.gengive";
            if (!player.hasPermission(permission)) {
                this.messagesManager.sendMessage((CommandSender)player, "no-permission");
                return true;
            }
        }
        ItemStack item = this.createGeneratorItem(level, isGemGenerator);
        item.setAmount(amount);
        Map<String, String> placeholders = MessagesManager.builder().add("amount", amount).add("level", level).add("player", targetPlayer.getName()).build();
        if (targetPlayer.getInventory().firstEmpty() == -1 && amount > 1) {
            HashMap leftover = targetPlayer.getInventory().addItem(new ItemStack[]{item});
            if (!leftover.isEmpty()) {
                int given = amount - ((ItemStack)leftover.get(0)).getAmount();
                placeholders.put("amount", String.valueOf(given));
                String successKey = isGemGenerator ? "gemgengive-success-other" : "gengive-success-other";
                this.messagesManager.sendMessage(sender, successKey, placeholders);
                if (sender != targetPlayer) {
                    placeholders.put("sender", sender.getName());
                    String targetKey = isGemGenerator ? "gemgengive-success-target" : "gengive-success-target";
                    this.messagesManager.sendMessage((CommandSender)targetPlayer, targetKey, placeholders);
                }
                this.messagesManager.sendMessage(sender, "inventory-full");
            } else {
                String successKey = sender.equals((Object)targetPlayer) ? (isGemGenerator ? "gemgengive-success-self" : "gengive-success-self") : (isGemGenerator ? "gemgengive-success-other" : "gengive-success-other");
                this.messagesManager.sendMessage(sender, successKey, placeholders);
                if (!sender.equals((Object)targetPlayer)) {
                    placeholders.put("sender", sender.getName());
                    String targetKey = isGemGenerator ? "gemgengive-success-target" : "gengive-success-target";
                    this.messagesManager.sendMessage((CommandSender)targetPlayer, targetKey, placeholders);
                }
            }
        } else {
            targetPlayer.getInventory().addItem(new ItemStack[]{item});
            String successKey = sender.equals((Object)targetPlayer) ? (isGemGenerator ? "gemgengive-success-self" : "gengive-success-self") : (isGemGenerator ? "gemgengive-success-other" : "gengive-success-other");
            this.messagesManager.sendMessage(sender, successKey, placeholders);
            if (!sender.equals((Object)targetPlayer)) {
                placeholders.put("sender", sender.getName());
                String targetKey = isGemGenerator ? "gemgengive-success-target" : "gengive-success-target";
                this.messagesManager.sendMessage((CommandSender)targetPlayer, targetKey, placeholders);
            }
        }
        return true;
    }

    private boolean handleGenStatsCommand(CommandSender sender, String[] args) {
        this.messagesManager.sendMessageNoPrefix(sender, "stats-header");
        sender.sendMessage("");
        int maxRegularLevel = this.config.getInt("max-generator-level", 20);
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "MONEY GENERATORS (Max Level " + maxRegularLevel + "):");
        for (int i = 1; i <= maxRegularLevel; ++i) {
            double spawnTime = (double)this.getGeneratorSpawnTime(i, false) / 20.0;
            String denomination = this.getMoneyDenominationForLevel(i);
            double upgradeCost = this.calculateUpgradeCost(i);
            double cashPerSecond = this.getDenominationValue(denomination, true) / spawnTime;
            sender.sendMessage(String.valueOf(ChatColor.WHITE) + "Level " + i + ": " + String.valueOf(ChatColor.GREEN) + denomination + " every " + String.format("%.1f", spawnTime) + "s " + String.valueOf(ChatColor.YELLOW) + "($" + String.format("%.2f", cashPerSecond) + "/s) " + (i < maxRegularLevel ? String.valueOf(ChatColor.AQUA) + "Upgrade: $" + String.format("%.0f", upgradeCost) : String.valueOf(ChatColor.RED) + "MAX"));
        }
        sender.sendMessage("");
        int maxGemLevel = this.config.getInt("max-gem-generator-level", 5);
        sender.sendMessage(String.valueOf(ChatColor.LIGHT_PURPLE) + "GEM GENERATORS (Max Level " + maxGemLevel + "):");
        for (int i = 1; i <= maxGemLevel; ++i) {
            double spawnTime = (double)this.getGeneratorSpawnTime(i, true) / 20.0;
            String denomination = this.getGemDenominationForLevel(i);
            double upgradeCost = this.calculateGemGenUpgradeCost(i);
            sender.sendMessage(String.valueOf(ChatColor.WHITE) + "Level " + i + ": " + String.valueOf(ChatColor.LIGHT_PURPLE) + denomination + " gem(s) every " + String.format("%.1f", spawnTime) + "s " + (i < maxGemLevel ? String.valueOf(ChatColor.AQUA) + "Upgrade: $" + String.format("%.0f", upgradeCost) : String.valueOf(ChatColor.RED) + "MAX"));
        }
        sender.sendMessage("");
        this.messagesManager.sendMessageNoPrefix(sender, "stats-total-server", MessagesManager.placeholder("total", String.valueOf(this.generatorManager.getTotalGeneratorCount())));
        if (sender instanceof Player) {
            Player player = (Player)sender;
            int placed = this.generatorManager.getPlayerGeneratorCount(player.getUniqueId());
            int baseLimit = this.config.getInt("base-generator-limit", 4);
            int extraFromPermissions = this.getExtraGenSlotsFromPermissions(player);
            int extraFromCommand = this.config.getInt("players." + String.valueOf(player.getUniqueId()) + ".extra-slots", 0);
            int maxGens = baseLimit + extraFromPermissions + extraFromCommand;
            int remaining = Math.max(0, maxGens - placed);
            Map<String, String> placeholders = MessagesManager.builder().add("placed", placed).add("limit", maxGens).add("remaining", remaining).add("base", baseLimit).add("perm", extraFromPermissions).add("extra", extraFromCommand).build();
            this.messagesManager.sendMessageNoPrefix(sender, "stats-your-generators", placeholders);
            this.messagesManager.sendMessageNoPrefix(sender, "stats-remaining-slots", placeholders);
            this.messagesManager.sendMessageNoPrefix(sender, "stats-base-limit", placeholders);
            this.messagesManager.sendMessageNoPrefix(sender, "stats-perm-bonus", placeholders);
            this.messagesManager.sendMessageNoPrefix(sender, "stats-extra-slots", placeholders);
        }
        this.messagesManager.sendMessageNoPrefix(sender, "stats-footer");
        return true;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockPlace(BlockPlaceEvent event) {
        String displayName;
        ItemStack item = event.getItemInHand();
        final Player player = event.getPlayer();
        if (item.hasItemMeta() && item.getItemMeta().hasDisplayName() && (displayName = ChatColor.stripColor((String)item.getItemMeta().getDisplayName())).contains("Generator")) {
            final int level = this.getGeneratorLevel(item);
            final boolean isGemGenerator = displayName.contains("Gem Generator");
            final Location loc = event.getBlockPlaced().getLocation();
            this.getServer().getScheduler().runTaskLater((Plugin)this, new Runnable(){
                final /* synthetic */ GensProY this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    int extraFromCommand;
                    int extraFromPermissions;
                    int baseLimit;
                    int maxGens;
                    Block placedBlock = loc.getBlock();
                    if (placedBlock.getType() == Material.AIR) {
                        this.this$0.messagesManager.sendMessage((CommandSender)player, "cannot-place-here");
                        return;
                    }
                    int currentGens = this.this$0.generatorManager.getPlayerGeneratorCount(player.getUniqueId());
                    if (currentGens >= (maxGens = (baseLimit = this.this$0.config.getInt("base-generator-limit", 4)) + (extraFromPermissions = this.this$0.getExtraGenSlotsFromPermissions(player)) + (extraFromCommand = this.this$0.config.getInt("players." + String.valueOf(player.getUniqueId()) + ".extra-slots", 0)))) {
                        this.this$0.messagesManager.sendMessage((CommandSender)player, "max-generators-reached", MessagesManager.builder().add("placed", currentGens).add("limit", maxGens).build());
                        placedBlock.setType(Material.AIR);
                        ItemStack generatorItem = this.this$0.createGeneratorItem(level, isGemGenerator);
                        player.getInventory().addItem(new ItemStack[]{generatorItem});
                        return;
                    }
                    try {
                        this.this$0.updateGeneratorAppearance(loc, level, isGemGenerator);
                        Material expectedMaterial = this.this$0.getGeneratorBlockType(level, isGemGenerator);
                        if (placedBlock.getType() != expectedMaterial) {
                            this.this$0.messagesManager.sendMessage((CommandSender)player, "cannot-place-here");
                            placedBlock.setType(Material.AIR);
                            ItemStack generatorItem = this.this$0.createGeneratorItem(level, isGemGenerator);
                            player.getInventory().addItem(new ItemStack[]{generatorItem});
                            return;
                        }
                    }
                    catch (Exception e) {
                        this.this$0.messagesManager.sendMessage((CommandSender)player, "cannot-place-here");
                        placedBlock.setType(Material.AIR);
                        ItemStack generatorItem = this.this$0.createGeneratorItem(level, isGemGenerator);
                        player.getInventory().addItem(new ItemStack[]{generatorItem});
                        return;
                    }
                    Generator gen = new Generator(loc, level, player.getUniqueId(), isGemGenerator);
                    this.this$0.generatorManager.addGenerator(loc, gen);
                    this.this$0.startGeneratorTask(gen);
                    this.this$0.messagesManager.sendMessage((CommandSender)player, "generator-placed");
                }
            }, 1L);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        Location loc = block.getLocation();
        if (this.generatorManager.isGenerator(loc)) {
            Generator gen = this.generatorManager.getGenerator(loc);
            Player player = event.getPlayer();
            UUID owner = gen.getOwner();
            if (!player.getUniqueId().equals(owner) && !player.hasPermission("gensproy.admin")) {
                event.setCancelled(true);
                this.messagesManager.sendMessage((CommandSender)player, "not-generator-owner");
                return;
            }
            event.setCancelled(true);
            String key = this.locationToString(loc);
            BukkitTask task = this.generatorTasks.get(key);
            if (task != null && !task.isCancelled()) {
                task.cancel();
                this.generatorTasks.remove(key);
            }
            this.generatorManager.removeGenerator(loc);
            ItemStack item = this.createGeneratorItem(gen.getLevel(), gen.isGemGenerator());
            if (player.getInventory().firstEmpty() == -1) {
                player.getWorld().dropItemNaturally(loc, item);
                this.messagesManager.sendMessage((CommandSender)player, "inventory-full");
            } else {
                player.getInventory().addItem(new ItemStack[]{item});
            }
            block.setType(Material.AIR);
            if (player.getUniqueId().equals(owner)) {
                this.messagesManager.sendMessage((CommandSender)player, "generator-broken");
            } else {
                Player ownerPlayer = this.getServer().getPlayer(owner);
                if (ownerPlayer != null && ownerPlayer.isOnline()) {
                    this.messagesManager.sendMessage((CommandSender)ownerPlayer, "generator-broken-by-admin", MessagesManager.placeholder("player", player.getName()));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockPhysics(BlockPhysicsEvent event) {
        Block block = event.getBlock();
        Location loc = block.getLocation();
        if (this.generatorManager.isGenerator(loc)) {
            Generator gen = this.generatorManager.getGenerator(loc);
            Material expectedType = this.getGeneratorBlockType(gen.getLevel(), gen.isGemGenerator());
            if (block.getType() != expectedType) {
                event.setCancelled(true);
                block.setType(expectedType);
            }
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!event.getPlayer().isSneaking()) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Location loc = block.getLocation();
        if (this.generatorManager.isGenerator(loc)) {
            double upgradeCost;
            int maxLevel;
            event.setCancelled(true);
            Player player = event.getPlayer();
            UUID playerId = player.getUniqueId();
            long currentTime = System.currentTimeMillis();
            Long lastUpgrade = this.upgradeCooldowns.get(playerId);
            if (lastUpgrade != null && currentTime - lastUpgrade < 500L) {
                return;
            }
            this.upgradeCooldowns.put(playerId, currentTime);
            Generator gen = this.generatorManager.getGenerator(loc);
            if (!player.getUniqueId().equals(gen.getOwner())) {
                this.messagesManager.sendMessage((CommandSender)player, "not-your-generator");
                return;
            }
            int n = maxLevel = gen.isGemGenerator() ? this.config.getInt("max-gem-generator-level", 5) : this.config.getInt("max-generator-level", 20);
            if (gen.getLevel() >= maxLevel) {
                this.messagesManager.sendMessage((CommandSender)player, "max-level-reached");
                return;
            }
            double d = upgradeCost = gen.isGemGenerator() ? this.calculateGemGenUpgradeCost(gen.getLevel()) : this.calculateUpgradeCost(gen.getLevel());
            if (this.economy.getBalance((OfflinePlayer)player) < upgradeCost) {
                this.messagesManager.sendMessage((CommandSender)player, "upgrade-insufficient-funds", MessagesManager.builder().add("cost", String.format("%.2f", upgradeCost)).add("balance", String.format("%.2f", this.economy.getBalance((OfflinePlayer)player))).build());
                return;
            }
            this.economy.withdrawPlayer((OfflinePlayer)player, upgradeCost);
            gen.setLevel(gen.getLevel() + 1);
            this.updateGeneratorAppearance(loc, gen.getLevel(), gen.isGemGenerator());
            String key = this.locationToString(loc);
            BukkitTask oldTask = this.generatorTasks.get(key);
            if (oldTask != null && !oldTask.isCancelled()) {
                oldTask.cancel();
            }
            this.startGeneratorTask(gen);
            this.generatorManager.saveGenerators();
            this.messagesManager.sendMessage((CommandSender)player, "generator-upgraded", MessagesManager.placeholder("level", String.valueOf(gen.getLevel())));
        }
    }

    private void startGeneratorTask(final Generator gen) {
        BukkitTask existingTask;
        final String locationKey = this.locationToString(gen.getLocation());
        if (this.generatorTasks.containsKey(locationKey) && (existingTask = this.generatorTasks.get(locationKey)) != null && !existingTask.isCancelled()) {
            existingTask.cancel();
        }
        long spawnTime = this.getGeneratorSpawnTime(gen.getLevel(), gen.isGemGenerator());
        BukkitTask task = new BukkitRunnable(this){
            final /* synthetic */ GensProY this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                boolean requireOwnerOnline = this.this$0.config.getBoolean("require-owner-online", true);
                if (requireOwnerOnline && !this.this$0.isOwnerOnline(gen.getOwner())) {
                    this.cancel();
                    this.this$0.generatorTasks.remove(locationKey);
                    return;
                }
                Location loc = gen.getLocation();
                Chunk chunk = loc.getChunk();
                if (!chunk.isLoaded()) {
                    return;
                }
                if (gen.isGemGenerator()) {
                    this.this$0.spawnGem(gen);
                } else {
                    double gemChance = this.this$0.config.getDouble("gem-spawn-chance", 1.0);
                    if (this.this$0.random.nextDouble() * 100.0 < gemChance) {
                        this.this$0.spawnGem(gen);
                    } else {
                        this.this$0.spawnMoney(gen);
                    }
                }
                gen.updateLastSpawnTime();
            }
        }.runTaskTimer((Plugin)this, spawnTime, spawnTime);
        this.generatorTasks.put(locationKey, task);
    }

    private void spawnMoney(Generator gen) {
        Location loc = gen.getLocation();
        String denomination = this.getMoneyDenominationForLevel(gen.getLevel());
        String command = this.config.getString("money-command", "paperx givemoney {world} {x} {y} {z} {denomination}");
        command = command.replace("{world}", loc.getWorld().getName()).replace("{x}", String.valueOf(loc.getBlockX())).replace("{y}", String.valueOf(loc.getBlockY() + 1)).replace("{z}", String.valueOf(loc.getBlockZ())).replace("{denomination}", denomination);
        this.getServer().dispatchCommand((CommandSender)this.getServer().getConsoleSender(), command);
    }

    private void spawnGem(Generator gen) {
        Location loc = gen.getLocation();
        String denomination = gen.isGemGenerator() ? this.getGemDenominationForLevel(gen.getLevel()) : this.config.getString("gem-denominations." + gen.getLevel(), "one");
        String command = this.config.getString("gem-command", "paperx givegem {world} {x} {y} {z} {denomination}");
        command = command.replace("{world}", loc.getWorld().getName()).replace("{x}", String.valueOf(loc.getBlockX())).replace("{y}", String.valueOf(loc.getBlockY() + 1)).replace("{z}", String.valueOf(loc.getBlockZ())).replace("{denomination}", denomination);
        this.getServer().dispatchCommand((CommandSender)this.getServer().getConsoleSender(), command);
    }

    private long getGeneratorSpawnTime(int level, boolean isGemGenerator) {
        String key = isGemGenerator ? "gem-spawn-times." + level : "spawn-times." + level;
        double seconds = this.config.getDouble(key, 10.0);
        return (long)(seconds * 20.0);
    }

    private String getMoneyDenominationForLevel(int level) {
        return this.config.getString("money-denominations." + level, "one");
    }

    private String getGemDenominationForLevel(int level) {
        return this.config.getString("gem-generator-denominations." + level, "one");
    }

    private double calculateUpgradeCost(int currentLevel) {
        return this.config.getDouble("upgrade-costs." + currentLevel, 1000.0);
    }

    private double calculateGemGenUpgradeCost(int currentLevel) {
        return this.config.getDouble("gem-upgrade-costs." + currentLevel, 5.0E7);
    }

    private double getDenominationValue(String denomination, boolean isMoney) {
        switch (denomination.toLowerCase()) {
            case "one": {
                return 1.0;
            }
            case "two": {
                return 2.0;
            }
            case "three": {
                return 3.0;
            }
            case "four": {
                return 4.0;
            }
            case "five": {
                return 5.0;
            }
            case "ten": {
                return 10.0;
            }
            case "twenty": {
                return 20.0;
            }
            case "fifty": {
                return 50.0;
            }
            case "hundred": {
                return 100.0;
            }
            case "fivehundred": {
                return 500.0;
            }
            case "thousand": {
                return 1000.0;
            }
            case "fivethousand": {
                return 5000.0;
            }
            case "tenthousand": {
                return 10000.0;
            }
        }
        return 1.0;
    }

    private Material getGeneratorBlockType(int level, boolean isGemGenerator) {
        if (isGemGenerator) {
            String blockTypeStr = this.config.getString("gem-generator-decorations.level-" + level + ".block-type", "AMETHYST_BLOCK");
            try {
                return Material.valueOf((String)blockTypeStr.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning(this.messagesManager.getConsoleMessage("console-invalid-block-type", MessagesManager.builder().add("type", blockTypeStr).add("level", level).build()));
                return Material.AMETHYST_BLOCK;
            }
        }
        String blockTypeStr = this.config.getString("generator-decorations.level-" + level + ".block-type", "WHITE_STAINED_GLASS");
        try {
            return Material.valueOf((String)blockTypeStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warning(this.messagesManager.getConsoleMessage("console-invalid-block-type", MessagesManager.builder().add("type", blockTypeStr).add("level", level).build()));
            return Material.WHITE_STAINED_GLASS;
        }
    }

    private void updateGeneratorAppearance(Location loc, int level, boolean isGemGenerator) {
        Block block = loc.getBlock();
        Material blockType = this.getGeneratorBlockType(level, isGemGenerator);
        block.setType(blockType);
    }

    private ItemStack createGeneratorItem(int level, boolean isGemGenerator) {
        Material blockType = this.getGeneratorBlockType(level, isGemGenerator);
        ItemStack item = new ItemStack(blockType);
        ItemMeta meta = item.getItemMeta();
        if (isGemGenerator) {
            double spawnTime = (double)this.getGeneratorSpawnTime(level, true) / 20.0;
            String denomination = this.getGemDenominationForLevel(level);
            int maxLevel = this.config.getInt("max-gem-generator-level", 5);
            double upgradeCost = level < maxLevel ? this.calculateGemGenUpgradeCost(level) : 0.0;
            Map<String, String> placeholders = MessagesManager.builder().add("level", level).add("value", denomination).add("time", String.format("%.1f", spawnTime)).add("cost", String.format("%.0f", upgradeCost)).build();
            meta.setDisplayName(this.messagesManager.getMessage("gem-generator-item-name", placeholders));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(this.messagesManager.getMessage("gem-generator-item-lore-place", placeholders));
            lore.add(this.messagesManager.getMessage("gem-generator-item-lore-level", placeholders));
            lore.add(this.messagesManager.getMessage("gem-generator-item-lore-produces", placeholders));
            lore.add(this.messagesManager.getMessage("gem-generator-item-lore-every", placeholders));
            lore.add(this.messagesManager.getMessage("gem-generator-item-lore-upgrade", placeholders));
            if (level < maxLevel) {
                lore.add(this.messagesManager.getMessage("gem-generator-item-lore-upgrade-cost", placeholders));
            } else {
                lore.add(this.messagesManager.getMessage("gem-generator-item-lore-max-level", placeholders));
            }
            meta.setLore(lore);
        } else {
            String denomination = this.getMoneyDenominationForLevel(level);
            double denominationValue = this.getDenominationValue(denomination, true);
            double spawnTime = (double)this.getGeneratorSpawnTime(level, false) / 20.0;
            double cashPerSecond = denominationValue / spawnTime;
            double gemChance = this.config.getDouble("gem-spawn-chance", 1.0);
            int maxLevel = this.config.getInt("max-generator-level", 20);
            double upgradeCost = level < maxLevel ? this.calculateUpgradeCost(level) : 0.0;
            Map<String, String> placeholders = MessagesManager.builder().add("level", level).add("value", String.format("%.0f", denominationValue)).add("time", String.format("%.1f", spawnTime)).add("rate", String.format("%.2f", cashPerSecond)).add("chance", String.format("%.1f", gemChance)).add("cost", String.format("%.0f", upgradeCost)).build();
            meta.setDisplayName(this.messagesManager.getMessage("generator-item-name", placeholders));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(this.messagesManager.getMessage("generator-item-lore-place", placeholders));
            lore.add(this.messagesManager.getMessage("generator-item-lore-level", placeholders));
            lore.add(this.messagesManager.getMessage("generator-item-lore-produces", placeholders));
            lore.add(this.messagesManager.getMessage("generator-item-lore-every", placeholders));
            lore.add(this.messagesManager.getMessage("generator-item-lore-rate", placeholders));
            lore.add(this.messagesManager.getMessage("generator-item-lore-gem-chance", placeholders));
            lore.add(this.messagesManager.getMessage("generator-item-lore-upgrade", placeholders));
            if (level < maxLevel) {
                lore.add(this.messagesManager.getMessage("generator-item-lore-upgrade-cost", placeholders));
            } else {
                lore.add(this.messagesManager.getMessage("generator-item-lore-max-level", placeholders));
            }
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
        return item;
    }

    private int getGeneratorLevel(ItemStack item) {
        String name;
        if (item.hasItemMeta() && item.getItemMeta().hasDisplayName() && (name = ChatColor.stripColor((String)item.getItemMeta().getDisplayName())).contains("Generator")) {
            String[] parts = name.split(" ");
            for (int i = 0; i < parts.length; ++i) {
                if (!parts[i].equalsIgnoreCase("Level") || i + 1 >= parts.length) continue;
                try {
                    return Integer.parseInt(parts[i + 1]);
                }
                catch (NumberFormatException e) {
                    return 1;
                }
            }
        }
        return 1;
    }

    public int getExtraGenSlotsFromPermissions(Player player) {
        if (player.hasPermission("gensproy.slots.all")) {
            return this.config.getInt("permission-slots.all", 16);
        }
        if (player.hasPermission("gensproy.slots.6")) {
            return 6;
        }
        if (player.hasPermission("gensproy.slots.4")) {
            return 4;
        }
        if (player.hasPermission("gensproy.slots.2")) {
            return 2;
        }
        return 0;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public String getPlaceholder(Player player, String identifier) {
        if (identifier.equals("gens_placed")) {
            int placed = this.generatorManager.getPlayerGeneratorCount(player.getUniqueId());
            int baseLimit = this.config.getInt("base-generator-limit", 4);
            int extraFromPermissions = this.getExtraGenSlotsFromPermissions(player);
            int extraFromCommand = this.config.getInt("players." + String.valueOf(player.getUniqueId()) + ".extra-slots", 0);
            int maxGens = baseLimit + extraFromPermissions + extraFromCommand;
            return placed + "/" + maxGens;
        }
        return null;
    }

    public GeneratorManager getGeneratorManager() {
        return this.generatorManager;
    }

    public MessagesManager getMessagesManager() {
        return this.messagesManager;
    }

    private void startAutoSaveTask() {
        new BukkitRunnable(){

            public void run() {
                if (GensProY.this.generatorManager != null) {
                    GensProY.this.generatorManager.forceSave();
                    GensProY.this.getLogger().info(GensProY.this.messagesManager.getConsoleMessage("console-auto-saved"));
                }
            }
        }.runTaskTimer((Plugin)this, 6000L, 6000L);
    }

    private String locationToString(Location loc) {
        return loc.getWorld().getName() + "," + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
    }
}

