/*
 * Decompiled with CFR 0.152.
 */
package com.gensproy;

import com.gensproy.GensProY;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;

public class GensProYPlaceholders
extends PlaceholderExpansion {
    private final GensProY plugin;

    public GensProYPlaceholders(GensProY plugin) {
        this.plugin = plugin;
    }

    public String getIdentifier() {
        return "gensproy";
    }

    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onPlaceholderRequest(Player player, String identifier) {
        if (player == null) {
            return "";
        }
        int placed = this.plugin.getGeneratorManager().getPlayerGeneratorCount(player.getUniqueId());
        int baseLimit = this.plugin.getConfig().getInt("base-generator-limit", 4);
        int extraFromPermissions = this.plugin.getExtraGenSlotsFromPermissions(player);
        int extraFromCommand = this.plugin.getConfig().getInt("players." + String.valueOf(player.getUniqueId()) + ".extra-slots", 0);
        int maxGens = baseLimit + extraFromPermissions + extraFromCommand;
        switch (identifier) {
            case "gens_placed": {
                return String.valueOf(placed);
            }
            case "gens_limit": {
                return String.valueOf(maxGens);
            }
            case "gens_remaining": {
                return String.valueOf(Math.max(0, maxGens - placed));
            }
            case "gens_progress": {
                return placed + "/" + maxGens;
            }
            case "gens_percent": {
                if (maxGens > 0) {
                    double percent = (double)placed / (double)maxGens * 100.0;
                    return String.format("%.1f%%", percent);
                }
                return "0.0%";
            }
            case "gens_base_limit": {
                return String.valueOf(baseLimit);
            }
            case "gens_perm_bonus": {
                return String.valueOf(extraFromPermissions);
            }
            case "gens_extra_slots": {
                return String.valueOf(extraFromCommand);
            }
        }
        return null;
    }
}

