/*
 * Decompiled with CFR 0.152.
 */
package com.gensproy;

import com.gensproy.GensProY;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class MessagesManager {
    private final GensProY plugin;
    private FileConfiguration messagesConfig;
    private File messagesFile;
    private final Map<String, String> messageCache = new HashMap<String, String>();

    public MessagesManager(GensProY plugin) {
        this.plugin = plugin;
        this.loadMessages();
    }

    public void loadMessages() {
        this.messageCache.clear();
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        try (InputStream defConfigStream = this.plugin.getResource("messages.yml");){
            if (defConfigStream != null) {
                YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
                this.messagesConfig.setDefaults((Configuration)defConfig);
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not load default messages.yml", e);
        }
        this.plugin.getLogger().info("Messages configuration loaded successfully!");
    }

    public void reloadMessages() {
        this.loadMessages();
    }

    private String getRawMessage(String key) {
        String message = this.messagesConfig.getString(key);
        if (message == null) {
            this.plugin.getLogger().warning("Missing message key: " + key);
            return "&cMissing message: " + key;
        }
        return message;
    }

    public String getMessage(String key) {
        if (this.messageCache.containsKey(key)) {
            return this.messageCache.get(key);
        }
        String message = this.getRawMessage(key);
        String colored = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        this.messageCache.put(key, colored);
        return colored;
    }

    public String getMessage(String key, Map<String, String> placeholders) {
        String message = this.getMessage(key);
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                message = message.replace("{" + entry.getKey() + "}", entry.getValue());
            }
        }
        return message;
    }

    public String getMessageWithPrefix(String key) {
        return this.getMessage("prefix") + " " + this.getMessage(key);
    }

    public String getMessageWithPrefix(String key, Map<String, String> placeholders) {
        return this.getMessage("prefix") + " " + this.getMessage(key, placeholders);
    }

    public void sendMessage(CommandSender sender, String key) {
        sender.sendMessage(this.getMessageWithPrefix(key));
    }

    public void sendMessage(CommandSender sender, String key, Map<String, String> placeholders) {
        sender.sendMessage(this.getMessageWithPrefix(key, placeholders));
    }

    public void sendMessageNoPrefix(CommandSender sender, String key) {
        sender.sendMessage(this.getMessage(key));
    }

    public void sendMessageNoPrefix(CommandSender sender, String key, Map<String, String> placeholders) {
        sender.sendMessage(this.getMessage(key, placeholders));
    }

    public void sendMessages(CommandSender sender, String ... keys) {
        for (String key : keys) {
            sender.sendMessage(this.getMessage(key));
        }
    }

    public static Map<String, String> placeholder(String key, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        return map;
    }

    public static Map<String, String> placeholders(String key1, String value1, String key2, String value2) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key1, value1);
        map.put(key2, value2);
        return map;
    }

    public static PlaceholderBuilder builder() {
        return new PlaceholderBuilder();
    }

    public FileConfiguration getMessagesConfig() {
        return this.messagesConfig;
    }

    public String getConsoleMessage(String key) {
        return this.getMessage(key);
    }

    public String getConsoleMessage(String key, Map<String, String> placeholders) {
        return this.getMessage(key, placeholders);
    }

    public void sendActionBar(Player player, String key) {
        String message = this.getMessage(key);
        try {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
        }
        catch (Exception e) {
            player.sendMessage(message);
        }
    }

    public void sendActionBar(Player player, String key, Map<String, String> placeholders) {
        String message = this.getMessage(key, placeholders);
        try {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
        }
        catch (Exception e) {
            player.sendMessage(message);
        }
    }

    public void sendTitle(Player player, String titleKey, String subtitleKey, int fadeIn, int stay, int fadeOut) {
        block2: {
            String title = this.getMessage(titleKey);
            String subtitle = this.getMessage(subtitleKey);
            try {
                Class playerClass = player.getClass();
                Method sendTitleMethod = playerClass.getMethod("sendTitle", String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                sendTitleMethod.invoke((Object)player, title, subtitle, fadeIn, stay, fadeOut);
            }
            catch (Exception e) {
                player.sendMessage(title);
                if (subtitle == null || subtitle.isEmpty()) break block2;
                player.sendMessage(subtitle);
            }
        }
    }

    public void sendTitle(Player player, String titleKey, String subtitleKey, Map<String, String> placeholders, int fadeIn, int stay, int fadeOut) {
        block2: {
            String title = this.getMessage(titleKey, placeholders);
            String subtitle = this.getMessage(subtitleKey, placeholders);
            try {
                Class playerClass = player.getClass();
                Method sendTitleMethod = playerClass.getMethod("sendTitle", String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                sendTitleMethod.invoke((Object)player, title, subtitle, fadeIn, stay, fadeOut);
            }
            catch (Exception e) {
                player.sendMessage(title);
                if (subtitle == null || subtitle.isEmpty()) break block2;
                player.sendMessage(subtitle);
            }
        }
    }

    public static class PlaceholderBuilder {
        private final Map<String, String> map = new HashMap<String, String>();

        public PlaceholderBuilder add(String key, String value) {
            this.map.put(key, value);
            return this;
        }

        public PlaceholderBuilder add(String key, int value) {
            this.map.put(key, String.valueOf(value));
            return this;
        }

        public PlaceholderBuilder add(String key, double value) {
            this.map.put(key, String.valueOf(value));
            return this;
        }

        public PlaceholderBuilder add(String key, long value) {
            this.map.put(key, String.valueOf(value));
            return this;
        }

        public Map<String, String> build() {
            return this.map;
        }
    }
}

