/*
 * Decompiled with CFR 0.152.
 */
package com.gxlg.vaultmanager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;

public class Memory {
    public Map<String, Set<String>> vaults = new HashMap<String, Set<String>>();
    private static final Path memoryPath = FabricLoader.getInstance().getConfigDir().resolve("vaultmanager.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static Memory init() {
        Memory memory;
        if (Files.notExists(memoryPath, new LinkOption[0])) {
            try {
                Files.createFile(memoryPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not initialize config", e);
            }
            memory = new Memory();
        } else {
            try (FileReader reader = new FileReader(memoryPath.toFile());){
                memory = (Memory)GSON.fromJson((Reader)reader, Memory.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not parse config", e);
            }
        }
        memory.save();
        return memory;
    }

    public void save() {
        Path dir = memoryPath.getParent();
        try {
            if (Files.notExists(dir, new LinkOption[0])) {
                Files.createDirectory(dir, new FileAttribute[0]);
            } else if (!Files.isDirectory(dir, new LinkOption[0])) {
                throw new IOException("Not a directory: " + String.valueOf(dir));
            }
            Path tempPath = memoryPath.resolveSibling(String.valueOf(memoryPath.getFileName()) + ".tmp");
            Files.createFile(tempPath, new FileAttribute[0]);
            Files.write(tempPath, GSON.toJson((Object)this).getBytes(), StandardOpenOption.WRITE);
            Files.move(tempPath, memoryPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save config", e);
        }
    }
}

