/*
 * Decompiled with CFR 0.152.
 */
package com.gxlg.vaultmanager;

import com.gxlg.vaultmanager.VaultManager;
import com.mojang.brigadier.context.CommandContext;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class Worker {
    private static String currentWorld = null;
    private static String lastChecked = null;

    public static void tick() {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        class_239 hit = client.field_1765;
        if (hit == null || hit.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        class_3965 blockHit = (class_3965)hit;
        class_638 world = client.field_1687;
        if (world == null || currentWorld == null) {
            return;
        }
        class_2338 pos = blockHit.method_17777();
        class_2248 block = world.method_8320(pos).method_26204();
        String posString = Worker.getPosString(pos);
        if (posString.equals(lastChecked)) {
            return;
        }
        lastChecked = posString;
        if (block != class_2246.field_48851) {
            return;
        }
        if (Worker.getVaults(true).contains(posString)) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Already opened").method_27692(class_124.field_1064), true);
        } else {
            player.method_7353((class_2561)class_2561.method_43470((String)"Not yet opened").method_27692(class_124.field_1060), true);
        }
    }

    private static String getPosString(class_2338 pos) {
        return pos.method_10263() + "," + pos.method_10264() + "," + pos.method_10260();
    }

    private static class_2338 posFromString(String pos) {
        String[] c = pos.split(",", 3);
        return new class_2338(Integer.parseInt(c[0]), Integer.parseInt(c[1]), Integer.parseInt(c[2]));
    }

    public static void setCurrentWorld(@Nullable String name) {
        currentWorld = name;
    }

    private static Set<String> getVaults(boolean directSave) {
        HashSet<String> vaults;
        if (!VaultManager.MEMORY.vaults.containsKey(currentWorld)) {
            vaults = new HashSet();
            VaultManager.MEMORY.vaults.put(currentWorld, vaults);
            if (directSave) {
                VaultManager.MEMORY.save();
            }
        } else {
            vaults = VaultManager.MEMORY.vaults.get(currentWorld);
        }
        return vaults;
    }

    public static boolean addOpenVault(class_2338 pos) {
        String posString = Worker.getPosString(pos);
        boolean s = Worker.getVaults(false).add(posString);
        VaultManager.MEMORY.save();
        return s;
    }

    public static int resetCurrentWorldCommand(CommandContext<FabricClientCommandSource> ctx) {
        Worker.getVaults(false).clear();
        VaultManager.MEMORY.save();
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Vaults cleared for this world!").method_27692(class_124.field_1064));
        return 0;
    }

    public static int queryNearestCommand(CommandContext<FabricClientCommandSource> ctx) {
        FabricClientCommandSource source = (FabricClientCommandSource)ctx.getSource();
        class_746 player = source.getPlayer();
        if (player.field_17892.method_27983() != class_1937.field_25179) {
            source.sendError((class_2561)class_2561.method_43470((String)"Vaults only spawn in the Overworld!").method_27692(class_124.field_1061));
            return 1;
        }
        Set<String> vaults = Worker.getVaults(false);
        if (vaults.isEmpty()) {
            source.sendError((class_2561)class_2561.method_43470((String)"No vaults have been opened yet!").method_27692(class_124.field_1061));
            return 1;
        }
        class_2338 cmp = player.method_24515();
        class_2338 pos = Worker.getVaults(false).stream().map(Worker::posFromString).min(Comparator.comparingInt(a -> a.method_19455((class_2382)cmp))).orElseThrow();
        String distance = new DecimalFormat("#0.00").format(Math.sqrt(pos.method_10262((class_2382)cmp)));
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("The nearest open vault is at [" + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260() + "] (" + distance + " block away)")).method_27692(class_124.field_1064));
        return 0;
    }
}

