/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.fractallightning;

import builderb0y.fractallightning.LightningRenderer;
import builderb0y.fractallightning.RNG;
import builderb0y.fractallightning.config.FractalLightningConfig;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import org.joml.Matrix4f;

public class LightningRendererImpl
extends LightningRenderer {
    public static final float baseWidth = 0.015625f;
    public static final float eighthWidth = 0.001953125f;
    public final float age;
    public final boolean rainbow;

    public LightningRendererImpl(Matrix4f modelViewMatrix, class_4588 buffer, float age) {
        super(modelViewMatrix, buffer);
        this.age = age;
        this.rainbow = FractalLightningConfig.instance().rainbow_mode.active;
    }

    @Override
    public float adjustWidth(float width, float startFrac, float endFrac) {
        if (this.age >= 8.0f) {
            return width - (this.age * 0.001953125f - 0.015625f);
        }
        if (startFrac >= this.age * 0.125f) {
            return 0.0f;
        }
        return width;
    }

    public static double square(double number) {
        return number * number;
    }

    public static double cosCurve(double number) {
        number *= number;
        return (1.0 - 16.0 * number) * (1.0 - 3.4336293856408275 * number);
    }

    public static double fastSin01(double angle) {
        return (angle -= Math.floor(angle)) <= 0.5 ? LightningRendererImpl.cosCurve(angle - 0.25) : -LightningRendererImpl.cosCurve(angle - 0.75);
    }

    public static double fastCos01(double angle) {
        return LightningRendererImpl.fastSin01(angle + 0.25);
    }

    @Override
    public void addQuads(float transformedStartX, float transformedStartY, float transformedStartZ, float startFrac, float transformedEndX, float transformedEndY, float transformedEndZ, float endFrac, float cameraDistanceSquared, float width) {
        int outerArgb;
        int innerArgb;
        if (this.rainbow) {
            double red = LightningRendererImpl.square(LightningRendererImpl.fastCos01(startFrac) * 0.5 + 0.5);
            double green = LightningRendererImpl.square(LightningRendererImpl.fastCos01((double)startFrac - 0.3333333333333333) * 0.5 + 0.5);
            double blue = LightningRendererImpl.square(LightningRendererImpl.fastCos01((double)startFrac - 0.6666666666666666) * 0.5 + 0.5);
            double rcpMagnitude = 1.0 / Math.sqrt(red * red + green * green + blue * blue);
            red = Math.sqrt(red * rcpMagnitude);
            green = Math.sqrt(green * rcpMagnitude);
            blue = Math.sqrt(blue * rcpMagnitude);
            innerArgb = class_5253.class_5254.method_27764((int)127, (int)Math.min((int)(red * 64.0 + 192.0), 255), (int)Math.min((int)(green * 64.0 + 192.0), 255), (int)Math.min((int)(blue * 64.0 + 192.0), 255));
            outerArgb = class_5253.class_5254.method_27764((int)0, (int)Math.min((int)(red * 256.0), 255), (int)Math.min((int)(green * 256.0), 255), (int)Math.min((int)(blue * 256.0), 255));
        } else {
            innerArgb = Integer.MAX_VALUE;
            outerArgb = 16255;
        }
        this.addColoredQuads(transformedStartX, transformedStartY, transformedStartZ, transformedEndX, transformedEndY, transformedEndZ, cameraDistanceSquared, width, innerArgb, outerArgb);
    }

    public void generatePoints(long seed) {
        long l = seed;
        long l2 = seed + -7046029254386353131L;
        seed = l2;
        seed = seed + -7046029254386353131L;
        this.generatePoints(l, RNG.nextUniformFloat(l2) * 32.0f, RNG.nextPositiveFloat(seed) * 64.0f + 128.0f, RNG.nextUniformFloat(seed += -7046029254386353131L) * 32.0f, 0.0f, 0.0f, 0.0f, 0.015625f);
    }
}

