/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.fractallightning;

public class RNG {
    public static final long PHI64 = -7046029254386353131L;

    public static long stafford(long z) {
        z = (z ^ z >>> 30) * -4658895280553007687L;
        z = (z ^ z >>> 27) * -7723592293110705685L;
        return z ^ z >>> 31;
    }

    public static long permute(long seed, int salt) {
        return RNG.stafford(seed + (long)salt * -7046029254386353131L);
    }

    public static float toPositiveFloat(long seed) {
        return (float)(seed >>> 40) * 5.9604645E-8f;
    }

    public static float toUniformFloat(long seed) {
        return (float)(seed >> 39) * 5.9604645E-8f;
    }

    public static double toPositiveDouble(long seed) {
        return (double)(seed >>> 11) * (double)1.110223E-16f;
    }

    public static double toUniformDouble(long seed) {
        return (double)(seed >> 10) * (double)1.110223E-16f;
    }

    public static float nextPositiveFloat(long seed) {
        return RNG.toPositiveFloat(RNG.stafford(seed));
    }

    public static float nextUniformFloat(long seed) {
        return RNG.toUniformFloat(RNG.stafford(seed));
    }

    public static double nextPositiveDouble(long seed) {
        return RNG.toPositiveDouble(RNG.stafford(seed));
    }

    public static double nextUniformDouble(long seed) {
        return RNG.toUniformDouble(RNG.stafford(seed));
    }
}

