/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.fractallightning.config;

import builderb0y.fractallightning.FractallightningClient;
import builderb0y.fractallightning.config.FractalLightningConfig;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.function.Predicate;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FractalLightningConfigLoader {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Fractal Lightning/Config");
    public static final String CONFIG_FILE_NAME = "Fractal Lightning.properties";
    public static final Path CONFIG_FOLDER = FabricLoader.getInstance().getConfigDir().toAbsolutePath();
    public static final Path CONFIG_FILE = CONFIG_FOLDER.resolve("Fractal Lightning.properties");
    public static final Path TMP_CONFIG_FILE = CONFIG_FOLDER.resolve("Fractal Lightning.properties.tmp");

    public static FractalLightningConfig load() throws Exception {
        if (Files.exists(CONFIG_FILE, new LinkOption[0])) {
            return FractalLightningConfigLoader.parse(Files.readString(CONFIG_FILE));
        }
        return new FractalLightningConfig();
    }

    public static void save(FractalLightningConfig config) throws Exception {
        config.validatePostLoad();
        Files.writeString(TMP_CONFIG_FILE, (CharSequence)FractalLightningConfigLoader.unparse(config), StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        Files.move(TMP_CONFIG_FILE, CONFIG_FILE, StandardCopyOption.REPLACE_EXISTING);
    }

    public static FractalLightningConfig loadAndSave() {
        FractalLightningConfig config;
        String oldText = null;
        if (Files.exists(CONFIG_FILE, new LinkOption[0])) {
            try {
                oldText = Files.readString(CONFIG_FILE, StandardCharsets.UTF_8);
                config = FractalLightningConfigLoader.parse(oldText);
            }
            catch (Exception exception) {
                LOGGER.warn("Could not parse Fractal Lightning.properties", (Throwable)exception);
                config = new FractalLightningConfig();
            }
        } else {
            config = new FractalLightningConfig();
        }
        try {
            String newText = FractalLightningConfigLoader.unparse(config);
            if (!newText.equals(oldText)) {
                Files.writeString(TMP_CONFIG_FILE, (CharSequence)newText, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                Files.move(TMP_CONFIG_FILE, CONFIG_FILE, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Could not save Fractal Lightning.properties", (Throwable)exception);
        }
        return config;
    }

    public static FractalLightningConfig parse(String text) {
        FractalLightningConfig config = new FractalLightningConfig();
        text.lines().map(String::trim).filter(Predicate.not(String::isEmpty)).filter(line -> line.charAt(0) != '#').forEach(line -> {
            block5: {
                int equals = line.indexOf(61);
                if (equals >= 0) {
                    try {
                        String key = line.substring(0, equals).trim();
                        String value = line.substring(equals + 1).trim();
                        Method method = FractalLightningConfig.class.getDeclaredMethod(key, String.class);
                        if (method.isAnnotationPresent(FractalLightningConfig.Loadable.class)) {
                            method.invoke((Object)config, value);
                            break block5;
                        }
                        LOGGER.warn("Ignoring malformed line " + line);
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Ignoring malformed line " + line);
                    }
                } else {
                    LOGGER.warn("Ignoring malformed line " + line);
                }
            }
        });
        return config;
    }

    public static String unparse(FractalLightningConfig config) throws Exception {
        JsonObject lang;
        try (InputStream stream = FractallightningClient.class.getResourceAsStream("/assets/fractallightning/lang/en_us.json");){
            if (stream == null) {
                throw new FileNotFoundException("/assets/fractallightning/lang/en_us.json");
            }
            lang = (JsonObject)JsonParser.parseReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
        }
        StringBuilder builder = new StringBuilder(1024);
        for (Method method : FractalLightningConfig.class.getDeclaredMethods()) {
            JsonElement element;
            if (!method.isAnnotationPresent(FractalLightningConfig.Savable.class)) continue;
            JsonElement element2 = lang.get("text.autoconfig.fractallightning.option." + method.getName() + ".@Tooltip");
            if (element2 != null) {
                builder.append('#').append(element2.getAsString()).append('\n');
            }
            int tooltipIndex = 0;
            while ((element = lang.get("text.autoconfig.fractallightning.option." + method.getName() + ".@Tooltip[" + tooltipIndex + "]")) != null) {
                builder.append('#').append(element.getAsString()).append('\n');
                ++tooltipIndex;
            }
            builder.append(method.getName()).append('=').append(method.invoke((Object)config, new Object[0])).append("\n\n");
        }
        builder.setLength(builder.length() - 2);
        return builder.toString();
    }
}

