/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.fractallightning.config;

import builderb0y.fractallightning.config.FractalLightningConfig;
import builderb0y.fractallightning.config.FractalLightningConfigLoader;
import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;

public class ClothConfigCompat {
    public static Supplier<FractalLightningConfig> init() {
        try {
            return ClothCode.initCloth();
        }
        catch (LinkageError error) {
            FractalLightningConfigLoader.LOGGER.info("Failed to register ConfigSerializer. Cloth Config is probably not installed.");
            return Suppliers.ofInstance((Object)FractalLightningConfigLoader.loadAndSave());
        }
    }

    public static class ClothCode {
        public static Supplier<FractalLightningConfig> initCloth() {
            AutoConfig.register(FractalLightningConfig.class.asSubclass(ConfigData.class), ClothCode::createSerializer);
            return AutoConfig.getConfigHolder(FractalLightningConfig.class.asSubclass(ConfigData.class));
        }

        public static ConfigSerializer<ConfigData> createSerializer(Config config, Class<?> clazz) {
            return new ConfigSerializer<ConfigData>(){

                public void serialize(ConfigData config) throws ConfigSerializer.SerializationException {
                    try {
                        FractalLightningConfigLoader.save((FractalLightningConfig)config);
                    }
                    catch (Exception exception) {
                        throw new ConfigSerializer.SerializationException((Throwable)exception);
                    }
                }

                public ConfigData deserialize() throws ConfigSerializer.SerializationException {
                    try {
                        return (ConfigData)FractalLightningConfigLoader.load();
                    }
                    catch (Exception exception) {
                        throw new ConfigSerializer.SerializationException((Throwable)exception);
                    }
                }

                public ConfigData createDefault() {
                    return (ConfigData)new FractalLightningConfig();
                }
            };
        }
    }
}

