/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.fractallightning.config;

import builderb0y.fractallightning.config.ClothConfigCompat;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.LocalDate;
import java.time.Month;
import java.util.Locale;
import java.util.function.Supplier;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;

@Config(name="fractallightning")
public class FractalLightningConfig {
    @ConfigEntry.Gui.Excluded
    public static final Supplier<FractalLightningConfig> INSTANCE = ClothConfigCompat.init();
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public RainbowMode rainbow_mode = RainbowMode.PRIDE_MONTH_ONLY;

    public static FractalLightningConfig instance() {
        return INSTANCE.get();
    }

    public static void init() {
    }

    public void validatePostLoad() {
    }

    @Savable
    public String rainbow_mode() {
        return this.rainbow_mode.name().toLowerCase(Locale.ROOT);
    }

    @Loadable
    public void rainbow_mode(String mode) {
        this.rainbow_mode = RainbowMode.valueOf(mode.toUpperCase(Locale.ROOT));
    }

    public static enum RainbowMode {
        PRIDE_MONTH_ONLY(LocalDate.now().getMonth() == Month.JUNE),
        ALWAYS(true);

        public final boolean active;

        private RainbowMode(boolean active) {
            this.active = active;
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Loadable {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Savable {
    }
}

