/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.fractallightning;

import builderb0y.fractallightning.FractalLightning;
import builderb0y.fractallightning.RNG;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1921;
import net.minecraft.class_4588;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public abstract class LightningRenderer {
    public static class_1921 LIGHTNING_LAYER;
    public final Matrix4f modelViewMatrix;
    public final Vector4f scratch;
    public final class_4588 buffer;

    public LightningRenderer(Matrix4f modelViewMatrix, class_4588 buffer) {
        this.modelViewMatrix = modelViewMatrix;
        this.scratch = new Vector4f();
        this.buffer = buffer;
    }

    public void generatePoints(long seed, float startX, float startY, float startZ, float endX, float endY, float endZ, float width) {
        this.modelViewMatrix.transform(this.scratch.set(startX, startY, startZ, 1.0f));
        float transformedStartX = this.scratch.x;
        float transformedStartY = this.scratch.y;
        float transformedStartZ = this.scratch.z;
        this.modelViewMatrix.transform(this.scratch.set(endX, endY, endZ, 1.0f));
        float transformedEndX = this.scratch.x;
        float transformedEndY = this.scratch.y;
        float transformedEndZ = this.scratch.z;
        this.generatePointsRecursive(seed, startX, startY, startZ, 0.0f, endX, endY, endZ, 1.0f, transformedStartX, transformedStartY, transformedStartZ, transformedEndX, transformedEndY, transformedEndZ, width);
    }

    public abstract float adjustWidth(float var1, float var2, float var3);

    public void generatePointsRecursive(long seed, float startX, float startY, float startZ, float startFrac, float endX, float endY, float endZ, float endFrac, float transformedStartX, float transformedStartY, float transformedStartZ, float transformedEndX, float transformedEndY, float transformedEndZ, float width) {
        float adjustedWidth = this.adjustWidth(width, startFrac, endFrac);
        if (!(adjustedWidth >= 0.0f)) {
            return;
        }
        float cameraDistanceSquared = Math.min(transformedStartX * transformedStartX + transformedStartY * transformedStartY + transformedStartZ * transformedStartZ, transformedEndX * transformedEndX + transformedEndY * transformedEndY + transformedEndZ * transformedEndZ);
        float dx = endX - startX;
        float dy = endY - startY;
        float dz = endZ - startZ;
        float segmentLengthSquared = dx * dx + dy * dy + dz * dz;
        if (segmentLengthSquared > 2.4414062E-4f && segmentLengthSquared > cameraDistanceSquared * 2.4414062E-4f) {
            long offsetSeed = RNG.stafford(seed ^ 0x84133286A32BEF3FL);
            float midX = (startX + endX) * 0.5f;
            float midY = (startY + endY) * 0.5f;
            float midZ = (startZ + endZ) * 0.5f;
            float midFrac = (startFrac + endFrac) * 0.5f;
            float offsetX = RNG.nextUniformFloat(offsetSeed += -7046029254386353131L);
            float offsetY = RNG.nextUniformFloat(offsetSeed += -7046029254386353131L);
            float offsetZ = RNG.nextUniformFloat(offsetSeed += -7046029254386353131L);
            float dot = (offsetX * dx + offsetY * dy + offsetZ * dz) / segmentLengthSquared;
            float currentLengthSquared = (offsetX -= dx * dot) * offsetX + (offsetY -= dy * dot) * offsetY + (offsetZ -= dz * dot) * offsetZ;
            float scalar = 0.1875f * (float)Math.sqrt(segmentLengthSquared / currentLengthSquared);
            float branchX = midX += (offsetX *= scalar);
            float branchY = midY += (offsetY *= scalar);
            float branchZ = midZ += (offsetZ *= scalar);
            offsetX = RNG.nextUniformFloat(offsetSeed += -7046029254386353131L);
            offsetY = RNG.nextUniformFloat(offsetSeed += -7046029254386353131L);
            offsetZ = RNG.nextUniformFloat(offsetSeed += -7046029254386353131L);
            float dot2 = (offsetX * dx + offsetY * dy + offsetZ * dz) / segmentLengthSquared;
            float currentLengthSquared2 = (offsetX -= dx * dot2) * offsetX + (offsetY -= dy * dot2) * offsetY + (offsetZ -= dz * dot2) * offsetZ;
            float scalar2 = 0.375f * (float)Math.sqrt(segmentLengthSquared / currentLengthSquared2);
            branchX += (offsetX *= scalar2);
            branchY += (offsetY *= scalar2);
            branchZ += (offsetZ *= scalar2);
            this.modelViewMatrix.transform(this.scratch.set(midX, midY, midZ, 1.0f));
            float transformedMidX = this.scratch.x;
            float transformedMidY = this.scratch.y;
            float transformedMidZ = this.scratch.z;
            this.modelViewMatrix.transform(this.scratch.set(branchX, branchY, branchZ, 1.0f));
            float transformedBranchX = this.scratch.x;
            float transformedBranchY = this.scratch.y;
            float transformedBranchZ = this.scratch.z;
            long splitSeed = RNG.stafford(seed ^ 0xB9287001C0AFFAD8L);
            this.generatePointsRecursive(RNG.permute(splitSeed, 1), startX, startY, startZ, startFrac, midX, midY, midZ, midFrac, transformedStartX, transformedStartY, transformedStartZ, transformedMidX, transformedMidY, transformedMidZ, width);
            this.generatePointsRecursive(RNG.permute(splitSeed, 2), midX, midY, midZ, midFrac, endX, endY, endZ, endFrac, transformedMidX, transformedMidY, transformedMidZ, transformedEndX, transformedEndY, transformedEndZ, width);
            this.generatePointsRecursive(RNG.permute(splitSeed, 3), midX, midY, midZ, midFrac, branchX, branchY, branchZ, endFrac, transformedMidX, transformedMidY, transformedMidZ, transformedBranchX, transformedBranchY, transformedBranchZ, width * 0.5f);
        } else {
            this.addQuads(transformedStartX, transformedStartY, transformedStartZ, startFrac, transformedEndX, transformedEndY, transformedEndZ, endFrac, cameraDistanceSquared, adjustedWidth);
        }
    }

    public abstract void addQuads(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10);

    public void addColoredQuads(float transformedStartX, float transformedStartY, float transformedStartZ, float transformedEndX, float transformedEndY, float transformedEndZ, float cameraDistanceSquared, float width, int innerArgb, int outerArgb) {
        float dx = transformedEndX - transformedStartX;
        float dy = transformedEndY - transformedStartY;
        float dz = transformedEndZ - transformedStartZ;
        float crossX = dz * transformedStartY - dy * transformedStartZ;
        float crossY = dx * transformedStartZ - dz * transformedStartX;
        float crossZ = dy * transformedStartX - dx * transformedStartY;
        float crossLengthSquared = crossX * crossX + crossY * crossY + crossZ * crossZ;
        float scalar = width * (float)Math.sqrt(cameraDistanceSquared / crossLengthSquared);
        this.vertex(transformedStartX + (crossX *= scalar), transformedStartY + (crossY *= scalar), transformedStartZ + (crossZ *= scalar), outerArgb);
        this.vertex(transformedEndX + crossX, transformedEndY + crossY, transformedEndZ + crossZ, outerArgb);
        this.vertex(transformedEndX, transformedEndY, transformedEndZ, innerArgb);
        this.vertex(transformedStartX, transformedStartY, transformedStartZ, innerArgb);
        this.vertex(transformedStartX, transformedStartY, transformedStartZ, innerArgb);
        this.vertex(transformedEndX, transformedEndY, transformedEndZ, innerArgb);
        this.vertex(transformedEndX - crossX, transformedEndY - crossY, transformedEndZ - crossZ, outerArgb);
        this.vertex(transformedStartX - crossX, transformedStartY - crossY, transformedStartZ - crossZ, outerArgb);
    }

    public void vertex(float x, float y, float z, int argb) {
        this.buffer.method_22912(x, y, z).method_39415(argb);
    }

    static {
        class_1921 layer = class_1921.method_23593();
        if (FabricLoader.getInstance().isModLoaded("iris")) {
            try {
                layer = (class_1921)Class.forName("net.irisshaders.iris.pathways.LightningHandler").getDeclaredField("IRIS_LIGHTNING").get(null);
                FractalLightning.LOGGER.info("Using new iris lightning render layer.");
            }
            catch (Exception exception) {
                try {
                    layer = (class_1921)Class.forName("net.coderbot.iris.pipeline.LightningHandler").getDeclaredField("IRIS_LIGHTNING").get(null);
                    FractalLightning.LOGGER.info("Using old iris lightning render layer.");
                }
                catch (Exception exception2) {
                    FractalLightning.LOGGER.warn("Could not locate Iris lightning render layer. Defaulting to vanilla.");
                }
            }
        }
        LIGHTNING_LAYER = layer;
    }
}

