/*
 * Decompiled with CFR 0.152.
 */
package io.hikarilan.gracefultransmission;

import io.hikarilan.gracefultransmission.GracefulTransmission;
import io.hikarilan.gracefultransmission.VirtualEntity;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class TransmissionProcess {
    private final GracefulTransmission plugin;
    private final Player player;
    private final Location to;
    private final VirtualEntity entity;

    public TransmissionProcess(GracefulTransmission plugin, Player player, Location to) {
        this.plugin = plugin;
        this.player = player;
        this.to = to;
        this.entity = new VirtualEntity(plugin, player);
        this.run();
    }

    private void run() {
        int upDuration = this.plugin.getUpDuration();
        int fadeInDuration = this.plugin.getFadeInDuration();
        int stayDuration = this.plugin.getStayDuration();
        int fadeOutDuration = this.plugin.getFadeOutDuration();
        int downDuration = this.plugin.getDownDuration();
        int downStayDuration = this.plugin.getDownStayDuration();
        Location upLocation = this.player.getLocation().clone().add(0.0, this.plugin.getUpOffset(), 0.0);
        upLocation.setPitch(90.0f);
        Location downLocation = this.to.clone();
        downLocation.setY(upLocation.getY());
        downLocation.setPitch(90.0f);
        this.entity.attach();
        this.entity.move(upLocation, upDuration);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            this.timeCycle(Math.max(0.0, this.plugin.getDayCycle()), fadeInDuration + stayDuration + fadeOutDuration + downDuration);
            if (this.plugin.isModifyWeather()) {
                this.player.setPlayerWeather(this.player.getWorld().isClearWeather() ? WeatherType.DOWNFALL : WeatherType.CLEAR);
            }
        }, (long)upDuration);
        if (upLocation.distanceSquared(downLocation) >= Math.pow(this.player.getWorld().getViewDistance() * 16, 2.0)) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.entity.move(upLocation.clone().add(downLocation.clone().subtract(upLocation.clone()).toVector().normalize().multiply(Math.pow(this.player.getWorld().getViewDistance(), 2.0))), stayDuration / 2), (long)(upDuration + fadeInDuration));
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                this.player.teleport(this.to, PlayerTeleportEvent.TeleportCause.SPECTATE);
                this.entity.teleport(downLocation.clone().subtract(downLocation.clone().subtract(upLocation.clone()).toVector().normalize().multiply(Math.pow(this.player.getWorld().getViewDistance(), 2.0))));
                this.entity.move(downLocation, stayDuration / 2);
            }, (long)(upDuration + fadeInDuration + stayDuration / 2));
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.entity.move(this.to, downDuration), (long)(upDuration + fadeInDuration + stayDuration + fadeOutDuration));
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.entity.move(downLocation, stayDuration), (long)(upDuration + fadeInDuration));
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                this.player.teleport(this.to, PlayerTeleportEvent.TeleportCause.SPECTATE);
                this.entity.move(this.to, downDuration);
            }, (long)(upDuration + fadeInDuration + stayDuration + fadeOutDuration));
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> ((Player)this.player).resetPlayerWeather(), (long)(upDuration + fadeInDuration + stayDuration + fadeOutDuration));
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> ((Player)this.player).resetPlayerTime(), (long)(upDuration + fadeInDuration + stayDuration + fadeOutDuration + downDuration));
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this.entity::detach, (long)(upDuration + fadeInDuration + stayDuration + fadeOutDuration + downDuration + downStayDuration));
    }

    private void timeCycle(double cycle, int duration) {
        AtomicInteger durationCounter = new AtomicInteger(duration);
        AtomicReference timer = new AtomicReference();
        long timeStep = (long)(cycle * 24000.0 / (double)duration);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> timer.set(Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            this.player.setPlayerTime(this.player.getPlayerTimeOffset() + timeStep, true);
            if (durationCounter.decrementAndGet() == 0) {
                ((BukkitTask)timer.get()).cancel();
            }
        }, 0L, 1L)));
    }
}

