/*
 * Decompiled with CFR 0.152.
 */
package io.hikarilan.gracefultransmission;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import io.hikarilan.gracefultransmission.GracefulTransmission;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class VirtualEntity {
    private final GracefulTransmission plugin;
    private final ProtocolManager protocolManager;
    private final Player player;
    private final int entityID;
    private Location location;

    public VirtualEntity(GracefulTransmission plugin, Player player) {
        this.plugin = plugin;
        this.protocolManager = plugin.getProtocolManager();
        this.player = player;
        this.entityID = -player.getEntityId();
        this.location = player.getLocation();
        this.spawn();
        this.setInvisible();
    }

    private void spawn() {
        boolean isAbove18 = this.plugin.getMinecraftVersion().getMinor() > 18;
        PacketContainer packet = isAbove18 ? this.protocolManager.createPacket(PacketType.Play.Server.SPAWN_ENTITY) : this.protocolManager.createPacket(PacketType.Play.Server.SPAWN_ENTITY_LIVING);
        packet.getModifier().writeDefaults();
        packet.getIntegers().write(0, (Object)this.entityID);
        packet.getUUIDs().write(0, (Object)UUID.randomUUID());
        packet.getIntegers().write(1, (Object)(isAbove18 ? 2 : 1));
        packet.getDoubles().write(0, (Object)this.location.getX()).write(1, (Object)this.location.getY()).write(2, (Object)this.location.getZ());
        packet.getBytes().write(0, (Object)((byte)(this.location.getYaw() * 256.0f / 360.0f))).write(1, (Object)((byte)(this.location.getPitch() * 256.0f / 360.0f))).write(2, (Object)((byte)(this.location.getYaw() * 256.0f / 360.0f)));
        this.protocolManager.sendServerPacket(this.player, packet);
    }

    private void setInvisible() {
        PacketContainer packet = this.protocolManager.createPacket(PacketType.Play.Server.ENTITY_METADATA);
        packet.getModifier().writeDefaults();
        packet.getIntegers().write(0, (Object)this.entityID);
        WrappedDataWatcher watcher = new WrappedDataWatcher();
        watcher.setObject(0, WrappedDataWatcher.Registry.get(Byte.class), (Object)32);
        packet.getWatchableCollectionModifier().write(0, (Object)watcher.getWatchableObjects());
        this.protocolManager.sendServerPacket(this.player, packet);
    }

    private void setPlayerSpectator(boolean reset) {
        PacketContainer packet = this.protocolManager.createPacket(PacketType.Play.Server.GAME_STATE_CHANGE);
        packet.getGameStateIDs().write(0, (Object)3);
        packet.getFloat().write(0, (Object)Float.valueOf(reset ? (float)this.player.getGameMode().getValue() : 3.0f));
        this.protocolManager.sendServerPacket(this.player, packet);
    }

    public void attach() {
        this.setPlayerSpectator(false);
        PacketContainer packet = this.protocolManager.createPacket(PacketType.Play.Server.CAMERA);
        packet.getIntegers().write(0, (Object)this.entityID);
        this.protocolManager.sendServerPacket(this.player, packet);
    }

    public void detach() {
        PacketContainer packet = this.protocolManager.createPacket(PacketType.Play.Server.CAMERA);
        packet.getIntegers().write(0, (Object)this.player.getEntityId());
        this.protocolManager.sendServerPacket(this.player, packet);
        this.setPlayerSpectator(true);
    }

    public void teleport(Location location) {
        this.location = location;
        PacketContainer packet = this.protocolManager.createPacket(PacketType.Play.Server.ENTITY_TELEPORT);
        packet.getModifier().writeDefaults();
        packet.getIntegers().write(0, (Object)this.entityID);
        packet.getDoubles().write(0, (Object)location.getX()).write(1, (Object)location.getY()).write(2, (Object)location.getZ());
        packet.getBytes().write(0, (Object)((byte)(location.getYaw() * 256.0f / 360.0f))).write(1, (Object)((byte)(location.getPitch() * 256.0f / 360.0f)));
        packet.getBooleans().write(0, (Object)false);
        this.protocolManager.sendServerPacket(this.player, packet);
    }

    private void lookAt(float headYaw) {
        PacketContainer packet = this.protocolManager.createPacket(PacketType.Play.Server.ENTITY_HEAD_ROTATION);
        packet.getModifier().writeDefaults();
        packet.getIntegers().write(0, (Object)this.entityID);
        packet.getBytes().write(0, (Object)((byte)(headYaw * 256.0f / 360.0f)));
        this.protocolManager.sendServerPacket(this.player, packet);
    }

    public void move(Location to, int duration) {
        AtomicInteger durationCounter = new AtomicInteger(duration);
        AtomicReference timer = new AtomicReference();
        double xStep = (to.getX() - this.location.getX()) / (double)duration;
        double yStep = (to.getY() - this.location.getY()) / (double)duration;
        double zStep = (to.getZ() - this.location.getZ()) / (double)duration;
        float yawStep = (to.getYaw() - this.location.getYaw()) / (float)duration;
        float pitchStep = (to.getPitch() - this.location.getPitch()) / (float)duration;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> timer.set(Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            this.location.add(xStep, yStep, zStep);
            this.location.setYaw(this.location.getYaw() + yawStep);
            this.location.setPitch(this.location.getPitch() + pitchStep);
            this.teleport(this.location);
            if (durationCounter.decrementAndGet() == 0) {
                ((BukkitTask)timer.get()).cancel();
            }
        }, 0L, 1L)));
    }
}

