/*
 * Decompiled with CFR 0.152.
 */
package quatum.no_attackcooldowndamagedelay;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="no_attack_cooldown_damage_delay")
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.ConfigValue<List<? extends String>> DamageDelay = BUILDER.comment("Damage types with delay between hits.").defineListAllowEmpty("DamageDelay", () -> List.of(Config.damageType_to_CorospoigString((ResourceKey<DamageType>)DamageTypes.IN_FIRE), Config.damageType_to_CorospoigString((ResourceKey<DamageType>)DamageTypes.CACTUS), Config.damageType_to_CorospoigString((ResourceKey<DamageType>)DamageTypes.HOT_FLOOR), Config.damageType_to_CorospoigString((ResourceKey<DamageType>)DamageTypes.FREEZE), Config.damageType_to_CorospoigString((ResourceKey<DamageType>)DamageTypes.LAVA), Config.damageType_to_CorospoigString((ResourceKey<DamageType>)DamageTypes.FELL_OUT_OF_WORLD), Config.damageType_to_CorospoigString((ResourceKey<DamageType>)DamageTypes.SWEET_BERRY_BUSH), Config.damageType_to_CorospoigString((ResourceKey<DamageType>)DamageTypes.IN_WALL), Config.damageType_to_CorospoigString((ResourceKey<DamageType>)DamageTypes.CAMPFIRE)), value -> true);
    private static final ModConfigSpec.ConfigValue<List<? extends String>> BlacklistedEntitys = BUILDER.comment("The Entity's with a delay between hits").defineListAllowEmpty("BlacklistedEntitys", () -> List.of("minecraft:magma_cube", "minecraft:slime"), value -> true);
    private static final ModConfigSpec.BooleanValue NoAttackCooldown = BUILDER.comment("Removes the players attack cooldown.").define("NoAttackCooldown", true);
    private static final ModConfigSpec.BooleanValue NoDamageDelay = BUILDER.comment("Removes the delay between hits.").define("NoDamageDelay", true);
    private static final ModConfigSpec.BooleanValue RemoveCooldownIndicator = BUILDER.comment("Removes the cooldown indikator wehen you punch").define("RemoveCooldownIndicator", true);
    private static final ModConfigSpec.BooleanValue LogDamage = BUILDER.comment("Logs the damage Types in the logs").define("LogDamage", false);
    static final ModConfigSpec SPEC = BUILDER.build();
    public static boolean NoAttackCooldownValue = true;
    public static boolean NoDamageDelayValue = true;
    public static boolean RemoveCooldownIndicatorValue = true;
    public static boolean LogDamageValue = false;
    public static List<String> damageTypesListValue = new ArrayList<String>();
    public static List<String> blacklistedEntitysValue = new ArrayList<String>();

    public static String damageType_to_CorospoigString(ResourceKey<DamageType> type) {
        return type.toString().split("/ ")[1].split("]")[0];
    }

    public static String entity_to_CotospoigStrig(Entity entity) {
        return String.valueOf(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()));
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        NoAttackCooldownValue = (Boolean)NoAttackCooldown.get();
        NoDamageDelayValue = (Boolean)NoDamageDelay.get();
        RemoveCooldownIndicatorValue = (Boolean)RemoveCooldownIndicator.get();
        damageTypesListValue = (List)DamageDelay.get();
        blacklistedEntitysValue = (List)BlacklistedEntitys.get();
        LogDamageValue = (Boolean)LogDamage.get();
    }
}

