/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemore_lib.items.armor.thunder_stone;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ThunderStoneArmorItem
extends ArmorItem {
    private static final ResourceLocation SPEED_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"cobblemore_lib", (String)"thunder_stone_speed_boost");
    private static final double SPEED_MULTIPLIER = 0.5;

    public ThunderStoneArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type slot, Item.Properties properties) {
        super(material, slot, properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.literal((String)"\u00a77Equipped with \u00a7eHaste II \u00a77and \u00a7e+50% Movement Speed"));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, level, entity, slot, selected);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack boots = (ItemStack)player.getInventory().armor.get(0);
        ItemStack legs = (ItemStack)player.getInventory().armor.get(1);
        ItemStack chest = (ItemStack)player.getInventory().armor.get(2);
        ItemStack head = (ItemStack)player.getInventory().armor.get(3);
        boolean fullSet = this.isThunderStoneArmor(boots) && this.isThunderStoneArmor(legs) && this.isThunderStoneArmor(chest) && this.isThunderStoneArmor(head);
        AttributeInstance movementAttr = player.getAttribute(Attributes.MOVEMENT_SPEED);
        if (movementAttr == null) {
            return;
        }
        if (fullSet) {
            player.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 220, 1, true, true));
            if (!movementAttr.hasModifier(SPEED_MODIFIER_ID)) {
                movementAttr.removeModifier(SPEED_MODIFIER_ID);
                movementAttr.addTransientModifier(this.getSpeedModifier());
            }
        } else if (movementAttr.hasModifier(SPEED_MODIFIER_ID)) {
            movementAttr.removeModifier(SPEED_MODIFIER_ID);
        }
    }

    private boolean isThunderStoneArmor(ItemStack stack) {
        return stack.getItem() instanceof ThunderStoneArmorItem;
    }

    private AttributeModifier getSpeedModifier() {
        return new AttributeModifier(SPEED_MODIFIER_ID, 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }
}

