/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemore_lib.items.armor.thunder_stone;

import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ThunderStoneArmorItem
extends ArmorItem {
    private static final UUID SPEED_BOOST_ID = UUID.fromString("c74b4827-6b3a-4f45-8723-ffb16df29d6b");
    private static final double SPEED_MULTIPLIER = 0.5;

    public ThunderStoneArmorItem(ArmorMaterial material, ArmorItem.Type slot, Item.Properties properties) {
        super(material, slot, properties);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237113_((String)"\u00a77Equipped with,\u00a74 \u201cHaste II\u201d, \u00a74 \u201c+50% Movement Speed\u201d."));
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        boolean fullSet;
        super.m_6883_(stack, level, entity, slot, selected);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack boots = (ItemStack)player.m_150109_().f_35975_.get(0);
        ItemStack legs = (ItemStack)player.m_150109_().f_35975_.get(1);
        ItemStack chest = (ItemStack)player.m_150109_().f_35975_.get(2);
        ItemStack head = (ItemStack)player.m_150109_().f_35975_.get(3);
        boolean bl = fullSet = this.isThunderStoneArmor(boots) && this.isThunderStoneArmor(legs) && this.isThunderStoneArmor(chest) && this.isThunderStoneArmor(head);
        if (fullSet) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 220, 1, true, true));
            if (!player.m_21051_(Attributes.f_22279_).m_22109_(this.getSpeedModifier())) {
                player.m_21051_(Attributes.f_22279_).m_22118_(this.getSpeedModifier());
            }
        } else if (player.m_21051_(Attributes.f_22279_).m_22109_(this.getSpeedModifier())) {
            player.m_21051_(Attributes.f_22279_).m_22120_(SPEED_BOOST_ID);
        }
    }

    private boolean isThunderStoneArmor(ItemStack stack) {
        return stack.m_41720_() instanceof ThunderStoneArmorItem;
    }

    private AttributeModifier getSpeedModifier() {
        return new AttributeModifier(SPEED_BOOST_ID, "Thunder Stone Speed Boost", 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }
}

