/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.potionring.item;

import com.google.common.collect.Lists;
import fr.samlegamer.potionring.PotionRing;
import fr.samlegamer.potionring.item.PotionRingItem;
import fr.samlegamer.potionring.item.PotionRingItemModded;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class PRItemsRegistry {
    public static final DeferredRegister.Items ITEMS_REGISTRY = DeferredRegister.createItems((String)"potionring");
    public static final DeferredHolder<Item, PotionRingItem> POTION_RING = ITEMS_REGISTRY.register("potion_ring", () -> new PotionRingItem("potion_ring", null));
    public static final DeferredHolder<Item, PotionRingItem> RING_OF_REGENERATION = ITEMS_REGISTRY.register("ring_of_regeneration", () -> new PotionRingItem("ring_of_regeneration", (Holder<MobEffect>)MobEffects.REGENERATION));
    public static final DeferredHolder<Item, PotionRingItem> RING_OF_HASTE = ITEMS_REGISTRY.register("ring_of_haste", () -> new PotionRingItem("ring_of_haste", (Holder<MobEffect>)MobEffects.HASTE));
    public static final DeferredHolder<Item, PotionRingItem> RING_OF_JUMP_BOOST = ITEMS_REGISTRY.register("ring_of_jump_boost", () -> new PotionRingItem("ring_of_jump_boost", (Holder<MobEffect>)MobEffects.JUMP_BOOST));
    public static final DeferredHolder<Item, PotionRingItem> RING_OF_RESISTANCE = ITEMS_REGISTRY.register("ring_of_resistance", () -> new PotionRingItem("ring_of_resistance", (Holder<MobEffect>)MobEffects.RESISTANCE));
    public static final DeferredHolder<Item, PotionRingItem> RING_OF_SPEED = ITEMS_REGISTRY.register("ring_of_speed", () -> new PotionRingItem("ring_of_speed", (Holder<MobEffect>)MobEffects.SPEED));
    public static final DeferredHolder<Item, PotionRingItem> RING_OF_STRENGTH = ITEMS_REGISTRY.register("ring_of_strengh", () -> new PotionRingItem("ring_of_strengh", (Holder<MobEffect>)MobEffects.STRENGTH));
    public static DeferredHolder<Item, PotionRingItem> RING_OF_FIRE_RESISTANCE;
    public static DeferredHolder<Item, PotionRingItem> RING_OF_INVISIBILITY;
    public static DeferredHolder<Item, PotionRingItem> RING_OF_SLOWNESS;
    public static DeferredHolder<Item, PotionRingItem> RING_OF_MINING_FATIGUE;
    public static DeferredHolder<Item, PotionRingItem> RING_OF_NAUSEA;
    public static DeferredHolder<Item, PotionRingItem> RING_OF_BLINDNESS;
    public static DeferredHolder<Item, PotionRingItem> RING_OF_HUNGER;
    public static DeferredHolder<Item, PotionRingItem> RING_OF_NIGHT_VISION;
    public static DeferredHolder<Item, PotionRingItem> RING_OF_SATURATION;
    public static DeferredHolder<Item, PotionRingItem> RING_OF_POISON;
    public static DeferredHolder<Item, PotionRingItem> RING_OF_WATER_BREATHING;
    public static DeferredHolder<Item, PotionRingItem> RING_OF_WEAKNESS;
    public static DeferredHolder<Item, PotionRingItem> RING_OF_WITHER;
    public static DeferredHolder<Item, PotionRingItem> RING_OF_GLOWING;
    public static DeferredHolder<Item, PotionRingItem> RING_OF_LEVITATION;
    public static DeferredHolder<Item, PotionRingItem> RING_OF_LUCK;
    public static DeferredHolder<Item, PotionRingItem> RING_OF_UNLUCK;
    public static DeferredHolder<Item, PotionRingItem> RING_OF_SLOW_FALLING;
    public static DeferredHolder<Item, PotionRingItem> RING_OF_CONDUIT_POWER;
    public static DeferredHolder<Item, PotionRingItem> RING_OF_DOLPHIN_GRACE;
    public static DeferredHolder<Item, PotionRingItem> RING_OF_DARKNESS;

    public static void registryVanillaRings() {
        RING_OF_FIRE_RESISTANCE = ITEMS_REGISTRY.register("ring_of_fire_resistance", () -> new PotionRingItem("ring_of_fire_resistance", (Holder<MobEffect>)MobEffects.FIRE_RESISTANCE));
        RING_OF_INVISIBILITY = ITEMS_REGISTRY.register("ring_of_invisibility", () -> new PotionRingItem("ring_of_invisibility", (Holder<MobEffect>)MobEffects.INVISIBILITY));
        RING_OF_SLOWNESS = ITEMS_REGISTRY.register("ring_of_slowness", () -> new PotionRingItem("ring_of_slowness", (Holder<MobEffect>)MobEffects.SLOWNESS));
        RING_OF_MINING_FATIGUE = ITEMS_REGISTRY.register("ring_of_mining_fatigue", () -> new PotionRingItem("ring_of_mining_fatigue", (Holder<MobEffect>)MobEffects.MINING_FATIGUE));
        RING_OF_NAUSEA = ITEMS_REGISTRY.register("ring_of_nausea", () -> new PotionRingItem("ring_of_nausea", (Holder<MobEffect>)MobEffects.NAUSEA));
        RING_OF_BLINDNESS = ITEMS_REGISTRY.register("ring_of_blindness", () -> new PotionRingItem("ring_of_blindness", (Holder<MobEffect>)MobEffects.BLINDNESS));
        RING_OF_HUNGER = ITEMS_REGISTRY.register("ring_of_hunger", () -> new PotionRingItem("ring_of_hunger", (Holder<MobEffect>)MobEffects.HUNGER));
        RING_OF_NIGHT_VISION = ITEMS_REGISTRY.register("ring_of_night_vision", () -> new PotionRingItem("ring_of_night_vision", (Holder<MobEffect>)MobEffects.NIGHT_VISION));
        RING_OF_SATURATION = ITEMS_REGISTRY.register("ring_of_saturation", () -> new PotionRingItem("ring_of_saturation", (Holder<MobEffect>)MobEffects.SATURATION));
        RING_OF_POISON = ITEMS_REGISTRY.register("ring_of_poison", () -> new PotionRingItem("ring_of_poison", (Holder<MobEffect>)MobEffects.POISON));
        RING_OF_WATER_BREATHING = ITEMS_REGISTRY.register("ring_of_water_breathing", () -> new PotionRingItem("ring_of_water_breathing", (Holder<MobEffect>)MobEffects.WATER_BREATHING));
        RING_OF_WEAKNESS = ITEMS_REGISTRY.register("ring_of_weakness", () -> new PotionRingItem("ring_of_weakness", (Holder<MobEffect>)MobEffects.WEAKNESS));
        RING_OF_WITHER = ITEMS_REGISTRY.register("ring_of_wither", () -> new PotionRingItem("ring_of_wither", (Holder<MobEffect>)MobEffects.WITHER));
        RING_OF_GLOWING = ITEMS_REGISTRY.register("ring_of_glowing", () -> new PotionRingItem("ring_of_glowing", (Holder<MobEffect>)MobEffects.GLOWING));
        RING_OF_LEVITATION = ITEMS_REGISTRY.register("ring_of_levitation", () -> new PotionRingItem("ring_of_levitation", (Holder<MobEffect>)MobEffects.LEVITATION));
        RING_OF_LUCK = ITEMS_REGISTRY.register("ring_of_luck", () -> new PotionRingItem("ring_of_luck", (Holder<MobEffect>)MobEffects.LUCK));
        RING_OF_UNLUCK = ITEMS_REGISTRY.register("ring_of_unluck", () -> new PotionRingItem("ring_of_unluck", (Holder<MobEffect>)MobEffects.UNLUCK));
        RING_OF_SLOW_FALLING = ITEMS_REGISTRY.register("ring_of_slow_falling", () -> new PotionRingItem("ring_of_slow_falling", (Holder<MobEffect>)MobEffects.SLOW_FALLING));
        RING_OF_CONDUIT_POWER = ITEMS_REGISTRY.register("ring_of_conduit_power", () -> new PotionRingItem("ring_of_conduit_power", (Holder<MobEffect>)MobEffects.CONDUIT_POWER));
        RING_OF_DOLPHIN_GRACE = ITEMS_REGISTRY.register("ring_of_dolphins_grace", () -> new PotionRingItem("ring_of_dolphins_grace", (Holder<MobEffect>)MobEffects.DOLPHINS_GRACE));
        RING_OF_DARKNESS = ITEMS_REGISTRY.register("ring_of_darkness", () -> new PotionRingItem("ring_of_darkness", (Holder<MobEffect>)MobEffects.DARKNESS));
    }

    public static List<?> createNewFileOrLearn(boolean returnColor) {
        Path file = Paths.get(FMLPaths.CONFIGDIR.get().toString(), "potionring.txt");
        if (!Files.exists(file, new LinkOption[0])) {
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
                bufferedWriter.write("examplemod:example_effect#15182205");
                bufferedWriter.newLine();
                bufferedWriter.write("examplemod:another_effect#12207722");
            }
            catch (IOException e) {
                PotionRing.log.warn("Error while creating potionring.txt");
            }
        }
        ArrayList lines = Lists.newArrayList();
        ArrayList colors = Lists.newArrayList();
        try (BufferedReader bufferedReader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            String line = bufferedReader.readLine();
            while (line != null) {
                String[] parts = line.split("#");
                if (parts.length == 2) {
                    int color = Integer.parseInt(parts[1]);
                    String modAndId = parts[0];
                    colors.add(color);
                    lines.add(modAndId);
                }
                line = bufferedReader.readLine();
            }
        }
        catch (IOException e) {
            PotionRing.log.warn("Error reading potionring.txt");
        }
        if (returnColor) {
            return colors;
        }
        return lines;
    }

    public static void registryModdedCustom(IEventBus bus) {
        DeferredRegister.Items IT = DeferredRegister.createItems((String)"potionring");
        DeferredItem RING_OF_GROWING = IT.register("ring_of_growing", () -> new PotionRingItemModded("sizeshiftingpotions", "growing"));
        DeferredItem RING_OF_SHRINKING = IT.register("ring_of_shrinking", () -> new PotionRingItemModded("sizeshiftingpotions", "shrinking"));
        DeferredItem RING_OF_THINNING = IT.register("ring_of_thinning", () -> new PotionRingItemModded("sizeshiftingpotions", "thinning"));
        DeferredItem RING_OF_WIDENING = IT.register("ring_of_widening", () -> new PotionRingItemModded("sizeshiftingpotions", "widening"));
        List<String> list = PRItemsRegistry.createNewFileOrLearn(false);
        if (!list.isEmpty()) {
            for (String s : list) {
                String[] parts = s.split(":");
                if (parts.length != 2) continue;
                String mod = parts[0];
                String id = parts[1];
                DeferredItem deferredItem = IT.register("ring_of_" + id, () -> new PotionRingItemModded(mod, id));
            }
        }
        IT.register(bus);
    }
}

