/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.potionring;

import fr.samlegamer.potionring.client.PRLang;
import fr.samlegamer.potionring.client.PRModels;
import fr.samlegamer.potionring.data.PRRecipes;
import fr.samlegamer.potionring.data.PRTags;
import fr.samlegamer.potionring.item.PRItemsRegistry;
import fr.samlegamer.potionring.item.PRTagsItemRegistry;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="potionring")
public class PotionRing {
    public static final String MODID = "potionring";
    public static final Logger log = LogManager.getLogger();

    public PotionRing(FMLJavaModLoadingContext javaModLoadingContext) {
        IEventBus bus = javaModLoadingContext.getModEventBus();
        PRItemsRegistry.ITEMS_REGISTRY.register(bus);
        PRTagsItemRegistry.registerTags();
        PRItemsRegistry.registryVanillaRings();
        PRItemsRegistry.registryModdedCustom(bus);
        bus.addListener(this::onGatherData);
        bus.addListener(this::addToTab);
        log.info("Potion Rings - REFORGED is Charged");
    }

    private void addToTab(BuildCreativeModeTabContentsEvent event) {
        List<String> list = PRItemsRegistry.createNewFileOrLearn(false);
        if (event.getTabKey() == CreativeModeTabs.FOOD_AND_DRINKS) {
            for (RegistryObject item : PRItemsRegistry.ITEMS_REGISTRY.getEntries()) {
                event.accept((Supplier)item);
            }
            if (!list.isEmpty()) {
                for (String s : list) {
                    String[] parts = s.split(":");
                    if (parts.length != 2) continue;
                    String mod = parts[0];
                    String id = parts[1];
                    Item itemModded = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)("ring_of_" + id)));
                    if (!ModList.get().isLoaded(mod)) continue;
                    event.accept((ItemLike)itemModded);
                }
            }
        }
    }

    private void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new PRModels(packOutput, existingFileHelper));
            generator.addProvider(true, (DataProvider)new PRLang(packOutput));
        }
        if (event.includeServer()) {
            PRTags.PRBlockTags blockTagGenerator = (PRTags.PRBlockTags)generator.addProvider(event.includeServer(), (DataProvider)new PRTags.PRBlockTags(packOutput, lookupProvider, existingFileHelper));
            generator.addProvider(true, (DataProvider)new PRRecipes(packOutput, lookupProvider));
            generator.addProvider(true, (DataProvider)new PRTags(packOutput, lookupProvider, blockTagGenerator.contentsGetter(), existingFileHelper));
        }
    }
}

