/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.potionring;

import fr.samlegamer.potionring.client.PRLang;
import fr.samlegamer.potionring.client.PRModels;
import fr.samlegamer.potionring.data.PRRecipes;
import fr.samlegamer.potionring.data.PRTags;
import fr.samlegamer.potionring.item.PRItemsRegistry;
import fr.samlegamer.potionring.item.PRTagsItemRegistry;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="potionring")
public class PotionRing {
    public static final String MODID = "potionring";
    public static final Logger log = LogManager.getLogger();

    public PotionRing(IEventBus bus) {
        bus.addListener(this::onGatherData);
        bus.addListener(this::addToTab);
        PRItemsRegistry.ITEMS_REGISTRY.register(bus);
        PRTagsItemRegistry.registerTags();
        PRItemsRegistry.registryVanillaRings();
        PRItemsRegistry.registryModdedCustom(bus);
        log.info("Potion Rings - REFORGED is Charged");
    }

    private void addToTab(BuildCreativeModeTabContentsEvent event) {
        List<String> list = PRItemsRegistry.createNewFileOrLearn(false);
        if (event.getTabKey() == CreativeModeTabs.FOOD_AND_DRINKS) {
            for (DeferredHolder item : PRItemsRegistry.ITEMS_REGISTRY.getEntries()) {
                event.accept((ItemLike)item.get());
            }
            if (ModList.get().isLoaded("sizeshiftingpotions")) {
                event.accept((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"ring_of_growing")));
                event.accept((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"ring_of_shrinking")));
                event.accept((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"ring_of_thinning")));
                event.accept((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"ring_of_widening")));
            }
            if (!list.isEmpty()) {
                for (String s : list) {
                    String[] parts = s.split(":");
                    if (parts.length != 2) continue;
                    String mod = parts[0];
                    String id = parts[1];
                    Item itemModded = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)("ring_of_" + id)));
                    if (!ModList.get().isLoaded(mod)) continue;
                    event.accept((ItemLike)itemModded);
                }
            }
        }
    }

    private void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new PRModels(packOutput, existingFileHelper));
            generator.addProvider(true, (DataProvider)new PRLang(packOutput));
        }
        if (event.includeServer()) {
            PRTags.PRBlockTags blockTagGenerator = (PRTags.PRBlockTags)generator.addProvider(event.includeServer(), (DataProvider)new PRTags.PRBlockTags(packOutput, lookupProvider, existingFileHelper));
            generator.addProvider(true, (DataProvider)new PRRecipes(packOutput, lookupProvider));
            generator.addProvider(true, (DataProvider)new PRTags(packOutput, lookupProvider, blockTagGenerator.contentsGetter(), existingFileHelper));
        }
    }
}

