/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.potionring.item;

import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class PotionRingItemModded
extends Item
implements ICurioItem {
    private final String mod;
    private final String name;

    public PotionRingItemModded(String mod, String name) {
        super(new Item.Properties().stacksTo(1).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"potionring", (String)("ring_of_" + name)))));
        this.mod = mod;
        this.name = name;
    }

    public boolean isCombineRepairable(ItemStack stack) {
        return stack.getItem() == Items.GOLD_INGOT;
    }

    public boolean canGrindstoneRepair(@NotNull ItemStack stack) {
        return true;
    }

    public boolean isFoil(@Nonnull ItemStack p_77636_1_) {
        return false;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Holder eff = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)((MobEffect)((Holder.Reference)BuiltInRegistries.MOB_EFFECT.get(ResourceLocation.fromNamespaceAndPath((String)this.mod, (String)this.name)).get()).value()));
        if (eff != null) {
            this.reloadEffect(slotContext.entity(), (Holder<MobEffect>)eff);
        }
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        Holder eff = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)((MobEffect)((Holder.Reference)BuiltInRegistries.MOB_EFFECT.get(ResourceLocation.fromNamespaceAndPath((String)this.mod, (String)this.name)).get()).value()));
        if (eff != null) {
            this.AddEffect(slotContext.entity(), (Holder<MobEffect>)eff);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        Holder eff = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)((MobEffect)((Holder.Reference)BuiltInRegistries.MOB_EFFECT.get(ResourceLocation.fromNamespaceAndPath((String)this.mod, (String)this.name)).get()).value()));
        if (eff != null) {
            this.DeleteEffect(slotContext.entity(), (Holder<MobEffect>)eff);
        }
    }

    private void AddEffect(LivingEntity livingEntity, Holder<MobEffect> mbEff) {
        if (CuriosApi.getCuriosInventory((LivingEntity)livingEntity).isPresent()) {
            MobEffectInstance effectInstance = new MobEffectInstance(mbEff, 240, ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)livingEntity).get()).findCurios((Item)this).size() - 1, true, true);
            livingEntity.addEffect(effectInstance);
        }
    }

    private void reloadEffect(LivingEntity livingEntity, Holder<MobEffect> mbEff) {
        int baseDuration = 240;
        int minDuration = 100;
        if (livingEntity.hasEffect(mbEff)) {
            MobEffectInstance currentEffect = livingEntity.getEffect(mbEff);
            if (currentEffect != null && currentEffect.getDuration() <= minDuration) {
                currentEffect.duration = baseDuration;
                livingEntity.addEffect(currentEffect);
            }
        } else if (!livingEntity.hasEffect(mbEff) && CuriosApi.getCuriosInventory((LivingEntity)livingEntity).isPresent() && ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)livingEntity).get()).findCurios((Item)this).size() == 1) {
            MobEffectInstance eff = new MobEffectInstance(mbEff, baseDuration, ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)livingEntity).get()).findCurios((Item)this).size() - 1, true, true);
            livingEntity.addEffect(eff);
        }
    }

    private void DeleteEffect(LivingEntity livingEntity, Holder<MobEffect> mbEff) {
        MobEffectInstance currentEffect = livingEntity.getEffect(mbEff);
        if (currentEffect != null && livingEntity.hasEffect(mbEff) && currentEffect.getAmplifier() > 0) {
            --currentEffect.amplifier;
            livingEntity.removeEffect(mbEff);
            livingEntity.addEffect(currentEffect);
        }
    }
}

