/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.potionring;

import fr.samlegamer.potionring.cfg.RingsConfig;
import fr.samlegamer.potionring.client.PRLang;
import fr.samlegamer.potionring.client.PRModels;
import fr.samlegamer.potionring.data.PRRecipes;
import fr.samlegamer.potionring.data.PRTags;
import fr.samlegamer.potionring.item.PRItemsRegistry;
import fr.samlegamer.potionring.item.PRTagsItemRegistry;
import java.util.ArrayList;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="potionring")
public class PotionRing {
    public static final String MODID = "potionring";
    public static final Logger log = LogManager.getLogger();

    public PotionRing() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RingsConfig.SPEC, "potionring-common.toml");
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onGatherData);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        PRItemsRegistry.ITEMS_REGISTRY.register(bus);
        PRTagsItemRegistry.registerTags();
        PRItemsRegistry.registryVanillaRings();
        PRItemsRegistry.registryModdedCustom(bus);
        log.info("Potion Rings - REFORGED is Charged");
    }

    private void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        if (event.includeClient()) {
            generator.m_236039_(true, (DataProvider)new PRModels(generator, existingFileHelper));
            generator.m_236039_(true, (DataProvider)new PRLang(generator));
        }
        if (event.includeServer()) {
            generator.m_236039_(true, (DataProvider)new PRRecipes(generator));
            generator.m_236039_(true, (DataProvider)new PRTags(generator, existingFileHelper));
        }
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        SlotTypePreset[] slots = new SlotTypePreset[]{SlotTypePreset.HEAD, SlotTypePreset.NECKLACE, SlotTypePreset.BACK, SlotTypePreset.BODY, SlotTypePreset.HANDS, SlotTypePreset.RING, SlotTypePreset.CHARM};
        ArrayList<SlotTypeMessage.Builder> builders = new ArrayList<SlotTypeMessage.Builder>();
        for (SlotTypePreset slot : slots) {
            SlotTypeMessage.Builder builder = slot.getMessageBuilder();
            if (slot == SlotTypePreset.RING) {
                builder.size(((Integer)RingsConfig.numberOfRingsSlots.get()).intValue());
            }
            builders.add(builder);
        }
        for (SlotTypeMessage.Builder builder : builders) {
            SlotTypeMessage message = builder.build();
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> message);
        }
    }
}

