/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.potionring;

import fr.samlegamer.potionring.client.PRLang;
import fr.samlegamer.potionring.client.PRModels;
import fr.samlegamer.potionring.data.PRRecipes;
import fr.samlegamer.potionring.data.PRTags;
import fr.samlegamer.potionring.item.PRItemsRegistry;
import fr.samlegamer.potionring.item.PRTagsItemRegistry;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="potionring")
public class PotionRing {
    public static final String MODID = "potionring";
    public static final Logger log = LogManager.getLogger();

    public PotionRing(IEventBus bus) {
        bus.addListener(this::onGatherClient);
        bus.addListener(this::client);
        bus.addListener(this::addToTab);
        PRItemsRegistry.ITEMS_REGISTRY.register(bus);
        PRTagsItemRegistry.registerTags();
        PRItemsRegistry.registryVanillaRings();
        PRItemsRegistry.registryModdedCustom(bus);
        log.info("Potion Rings - REFORGED is Charged");
    }

    private void client(FMLClientSetupEvent event) {
        for (DeferredHolder item : PRItemsRegistry.ITEMS_REGISTRY.getEntries()) {
            AccessoriesRendererRegistry.bindItemToRenderer((Item)((Item)item.get()), (ResourceLocation)AccessoriesRendererRegistry.NO_RENDERER_ID);
        }
        AccessoriesRendererRegistry.bindItemToRenderer((Item)((Item)((Holder.Reference)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"ring_of_growing")).get()).value()), (ResourceLocation)AccessoriesRendererRegistry.NO_RENDERER_ID);
        AccessoriesRendererRegistry.bindItemToRenderer((Item)((Item)((Holder.Reference)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"ring_of_shrinking")).get()).value()), (ResourceLocation)AccessoriesRendererRegistry.NO_RENDERER_ID);
        AccessoriesRendererRegistry.bindItemToRenderer((Item)((Item)((Holder.Reference)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"ring_of_thinning")).get()).value()), (ResourceLocation)AccessoriesRendererRegistry.NO_RENDERER_ID);
        AccessoriesRendererRegistry.bindItemToRenderer((Item)((Item)((Holder.Reference)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"ring_of_widening")).get()).value()), (ResourceLocation)AccessoriesRendererRegistry.NO_RENDERER_ID);
        List<String> list = PRItemsRegistry.createNewFileOrLearn(false);
        if (!list.isEmpty()) {
            for (String s : list) {
                String[] parts = s.split(":");
                if (parts.length != 2) continue;
                String mod = parts[0];
                String id = parts[1];
                Item itemModded = (Item)((Holder.Reference)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)("ring_of_" + id))).get()).value();
                if (!ModList.get().isLoaded(mod)) continue;
                AccessoriesRendererRegistry.bindItemToRenderer((Item)itemModded, (ResourceLocation)AccessoriesRendererRegistry.NO_RENDERER_ID);
            }
        }
    }

    private void addToTab(BuildCreativeModeTabContentsEvent event) {
        List<String> list = PRItemsRegistry.createNewFileOrLearn(false);
        if (event.getTabKey() == CreativeModeTabs.FOOD_AND_DRINKS) {
            for (DeferredHolder item : PRItemsRegistry.ITEMS_REGISTRY.getEntries()) {
                event.accept((ItemLike)item.get());
            }
            if (ModList.get().isLoaded("sizeshiftingpotions")) {
                event.accept((ItemLike)((Holder.Reference)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"ring_of_growing")).get()).value());
                event.accept((ItemLike)((Holder.Reference)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"ring_of_shrinking")).get()).value());
                event.accept((ItemLike)((Holder.Reference)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"ring_of_thinning")).get()).value());
                event.accept((ItemLike)((Holder.Reference)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"ring_of_widening")).get()).value());
            }
            if (!list.isEmpty()) {
                for (String s : list) {
                    String[] parts = s.split(":");
                    if (parts.length != 2) continue;
                    String mod = parts[0];
                    String id = parts[1];
                    Item itemModded = (Item)((Holder.Reference)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)("ring_of_" + id))).get()).value();
                    if (!ModList.get().isLoaded(mod)) continue;
                    event.accept((ItemLike)itemModded);
                }
            }
        }
    }

    private void onGatherClient(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = event.getGenerator().getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        PRTags.PRBlockTags blockTagGenerator = (PRTags.PRBlockTags)generator.addProvider(true, (DataProvider)new PRTags.PRBlockTags(output, lookupProvider));
        generator.addProvider(true, (DataProvider)new PRRecipes.Runner(output, lookupProvider));
        generator.addProvider(true, (DataProvider)new PRTags(output, lookupProvider, blockTagGenerator.contentsGetter()));
        generator.addProvider(true, (DataProvider)new PRLang(output));
        generator.addProvider(true, (DataProvider)new PRModels(output));
    }
}

