/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.potionring.item;

import io.wispforest.accessories.api.core.AccessoryItem;
import io.wispforest.accessories.api.slot.SlotReference;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class PotionRingItemModded
extends AccessoryItem {
    private final String mod;
    private final String name;

    public PotionRingItemModded(String mod, String name) {
        super(new Item.Properties().stacksTo(1).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"potionring", (String)("ring_of_" + name)))));
        this.mod = mod;
        this.name = name;
    }

    public boolean isCombineRepairable(ItemStack stack) {
        return stack.getItem() == Items.GOLD_INGOT;
    }

    public boolean canGrindstoneRepair(@NotNull ItemStack stack) {
        return true;
    }

    public boolean isFoil(@Nonnull ItemStack p_77636_1_) {
        return false;
    }

    public void tick(ItemStack stack, SlotReference reference) {
        Holder eff = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)((MobEffect)((Holder.Reference)BuiltInRegistries.MOB_EFFECT.get(ResourceLocation.fromNamespaceAndPath((String)this.mod, (String)this.name)).get()).value()));
        if (eff != null) {
            this.reloadMobEffect(reference, (Holder<MobEffect>)eff);
        }
    }

    public void onEquip(ItemStack stack, SlotReference reference) {
        Holder eff = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)((MobEffect)((Holder.Reference)BuiltInRegistries.MOB_EFFECT.get(ResourceLocation.fromNamespaceAndPath((String)this.mod, (String)this.name)).get()).value()));
        if (eff != null) {
            this.AddMobEffect(reference, (Holder<MobEffect>)eff);
        }
    }

    public void onUnequip(ItemStack stack, SlotReference reference) {
        Holder eff = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)((MobEffect)((Holder.Reference)BuiltInRegistries.MOB_EFFECT.get(ResourceLocation.fromNamespaceAndPath((String)this.mod, (String)this.name)).get()).value()));
        if (eff != null) {
            this.DeleteMobEffect(reference, (Holder<MobEffect>)eff);
        }
    }

    private void AddMobEffect(SlotReference slotReference, Holder<MobEffect> mbEff) {
        MobEffectInstance effectInstance = new MobEffectInstance(mbEff, mbEff == MobEffects.NIGHT_VISION ? 500 : 240, slotReference.slotContainer().getAccessories().countItem((Item)this) - 1, true, true);
        slotReference.entity().addEffect(effectInstance);
    }

    private void reloadMobEffect(SlotReference slotReference, Holder<MobEffect> mbEff) {
        int minDuration;
        int baseDuration = mbEff == MobEffects.NIGHT_VISION ? 500 : 240;
        int n = minDuration = mbEff == MobEffects.NIGHT_VISION ? 240 : 100;
        if (slotReference.entity().hasEffect(mbEff)) {
            MobEffectInstance currentMobEffect = slotReference.entity().getEffect(mbEff);
            if (currentMobEffect != null) {
                int ringAmplifier = 0;
                if (slotReference.slotContainer().getAccessories() != null) {
                    ringAmplifier = slotReference.slotContainer().getAccessories().countItem((Item)this) - 1;
                }
                if (currentMobEffect.getAmplifier() > ringAmplifier) {
                    return;
                }
                if (currentMobEffect.getDuration() <= minDuration) {
                    currentMobEffect.duration = baseDuration;
                    slotReference.entity().addEffect(currentMobEffect);
                }
            }
        } else if (!slotReference.entity().hasEffect(mbEff) && slotReference.slotContainer().getAccessories().countItem((Item)this) == 1) {
            MobEffectInstance eff = new MobEffectInstance(mbEff, baseDuration, slotReference.slotContainer().getAccessories().countItem((Item)this) - 1, true, true);
            slotReference.entity().addEffect(eff);
        }
    }

    private void DeleteMobEffect(SlotReference slotReference, Holder<MobEffect> mbEff) {
        MobEffectInstance currentMobEffect = slotReference.entity().getEffect(mbEff);
        if (currentMobEffect != null && slotReference.entity().hasEffect(mbEff) && currentMobEffect.getAmplifier() > 0) {
            --currentMobEffect.amplifier;
            slotReference.entity().removeEffect(mbEff);
            slotReference.entity().addEffect(currentMobEffect);
        }
    }
}

