/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.potionring.item;

import com.google.common.collect.Lists;
import fr.samlegamer.potionring.PotionRing;
import fr.samlegamer.potionring.item.PotionRingItem;
import fr.samlegamer.potionring.item.PotionRingItemModded;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class PRItemsRegistry {
    public static final DeferredRegister<Item> ITEMS_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"potionring");
    public static final RegistryObject<PotionRingItem> POTION_RING = ITEMS_REGISTRY.register("potion_ring", () -> new PotionRingItem(null));
    public static final RegistryObject<PotionRingItem> RING_OF_REGENERATION = ITEMS_REGISTRY.register("ring_of_regeneration", () -> new PotionRingItem(MobEffects.f_19605_));
    public static final RegistryObject<PotionRingItem> RING_OF_HASTE = ITEMS_REGISTRY.register("ring_of_haste", () -> new PotionRingItem(MobEffects.f_19598_));
    public static final RegistryObject<PotionRingItem> RING_OF_JUMP_BOOST = ITEMS_REGISTRY.register("ring_of_jump_boost", () -> new PotionRingItem(MobEffects.f_19603_));
    public static final RegistryObject<PotionRingItem> RING_OF_RESISTANCE = ITEMS_REGISTRY.register("ring_of_resistance", () -> new PotionRingItem(MobEffects.f_19606_));
    public static final RegistryObject<PotionRingItem> RING_OF_SPEED = ITEMS_REGISTRY.register("ring_of_speed", () -> new PotionRingItem(MobEffects.f_19596_));
    public static final RegistryObject<PotionRingItem> RING_OF_STRENGTH = ITEMS_REGISTRY.register("ring_of_strengh", () -> new PotionRingItem(MobEffects.f_19600_));
    public static RegistryObject<PotionRingItem> RING_OF_FIRE_RESISTANCE;
    public static RegistryObject<PotionRingItem> RING_OF_INVISIBILITY;
    public static RegistryObject<PotionRingItem> RING_OF_SLOWNESS;
    public static RegistryObject<PotionRingItem> RING_OF_MINING_FATIGUE;
    public static RegistryObject<PotionRingItem> RING_OF_NAUSEA;
    public static RegistryObject<PotionRingItem> RING_OF_BLINDNESS;
    public static RegistryObject<PotionRingItem> RING_OF_HUNGER;
    public static RegistryObject<PotionRingItem> RING_OF_NIGHT_VISION;
    public static RegistryObject<PotionRingItem> RING_OF_SATURATION;
    public static RegistryObject<PotionRingItem> RING_OF_POISON;
    public static RegistryObject<PotionRingItem> RING_OF_WATER_BREATHING;
    public static RegistryObject<PotionRingItem> RING_OF_WEAKNESS;
    public static RegistryObject<PotionRingItem> RING_OF_WITHER;
    public static RegistryObject<PotionRingItem> RING_OF_GLOWING;
    public static RegistryObject<PotionRingItem> RING_OF_LEVITATION;
    public static RegistryObject<PotionRingItem> RING_OF_LUCK;
    public static RegistryObject<PotionRingItem> RING_OF_UNLUCK;
    public static RegistryObject<PotionRingItem> RING_OF_SLOW_FALLING;
    public static RegistryObject<PotionRingItem> RING_OF_CONDUIT_POWER;
    public static RegistryObject<PotionRingItem> RING_OF_DOLPHIN_GRACE;
    public static RegistryObject<PotionRingItem> RING_OF_DARKNESS;

    public static void registryVanillaRings() {
        RING_OF_FIRE_RESISTANCE = ITEMS_REGISTRY.register("ring_of_fire_resistance", () -> new PotionRingItem(MobEffects.f_19607_));
        RING_OF_INVISIBILITY = ITEMS_REGISTRY.register("ring_of_invisibility", () -> new PotionRingItem(MobEffects.f_19609_));
        RING_OF_SLOWNESS = ITEMS_REGISTRY.register("ring_of_slowness", () -> new PotionRingItem(MobEffects.f_19597_));
        RING_OF_MINING_FATIGUE = ITEMS_REGISTRY.register("ring_of_mining_fatigue", () -> new PotionRingItem(MobEffects.f_19599_));
        RING_OF_NAUSEA = ITEMS_REGISTRY.register("ring_of_nausea", () -> new PotionRingItem(MobEffects.f_19604_));
        RING_OF_BLINDNESS = ITEMS_REGISTRY.register("ring_of_blindness", () -> new PotionRingItem(MobEffects.f_19610_));
        RING_OF_HUNGER = ITEMS_REGISTRY.register("ring_of_hunger", () -> new PotionRingItem(MobEffects.f_19612_));
        RING_OF_NIGHT_VISION = ITEMS_REGISTRY.register("ring_of_night_vision", () -> new PotionRingItem(MobEffects.f_19611_));
        RING_OF_SATURATION = ITEMS_REGISTRY.register("ring_of_saturation", () -> new PotionRingItem(MobEffects.f_19618_));
        RING_OF_POISON = ITEMS_REGISTRY.register("ring_of_poison", () -> new PotionRingItem(MobEffects.f_19614_));
        RING_OF_WATER_BREATHING = ITEMS_REGISTRY.register("ring_of_water_breathing", () -> new PotionRingItem(MobEffects.f_19608_));
        RING_OF_WEAKNESS = ITEMS_REGISTRY.register("ring_of_weakness", () -> new PotionRingItem(MobEffects.f_19613_));
        RING_OF_WITHER = ITEMS_REGISTRY.register("ring_of_wither", () -> new PotionRingItem(MobEffects.f_19615_));
        RING_OF_GLOWING = ITEMS_REGISTRY.register("ring_of_glowing", () -> new PotionRingItem(MobEffects.f_19619_));
        RING_OF_LEVITATION = ITEMS_REGISTRY.register("ring_of_levitation", () -> new PotionRingItem(MobEffects.f_19620_));
        RING_OF_LUCK = ITEMS_REGISTRY.register("ring_of_luck", () -> new PotionRingItem(MobEffects.f_19621_));
        RING_OF_UNLUCK = ITEMS_REGISTRY.register("ring_of_unluck", () -> new PotionRingItem(MobEffects.f_19590_));
        RING_OF_SLOW_FALLING = ITEMS_REGISTRY.register("ring_of_slow_falling", () -> new PotionRingItem(MobEffects.f_19591_));
        RING_OF_CONDUIT_POWER = ITEMS_REGISTRY.register("ring_of_conduit_power", () -> new PotionRingItem(MobEffects.f_19592_));
        RING_OF_DOLPHIN_GRACE = ITEMS_REGISTRY.register("ring_of_dolphins_grace", () -> new PotionRingItem(MobEffects.f_19593_));
        RING_OF_DARKNESS = ITEMS_REGISTRY.register("ring_of_darkness", () -> new PotionRingItem(MobEffects.f_216964_));
    }

    public static List<?> createNewFileOrLearn(boolean returnColor) {
        Path file = Paths.get(FMLPaths.CONFIGDIR.get().toString(), "potionring.txt");
        if (!Files.exists(file, new LinkOption[0])) {
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
                bufferedWriter.write("examplemod:example_effect#15182205");
                bufferedWriter.newLine();
                bufferedWriter.write("examplemod:another_effect#12207722");
            }
            catch (IOException e) {
                PotionRing.log.warn("Error while creating potionring.txt");
            }
        }
        ArrayList lines = Lists.newArrayList();
        ArrayList colors = Lists.newArrayList();
        try (BufferedReader bufferedReader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            String line = bufferedReader.readLine();
            while (line != null) {
                String[] parts = line.split("#");
                if (parts.length == 2) {
                    int color = Integer.parseInt(parts[1]);
                    String modAndId = parts[0];
                    colors.add(color);
                    lines.add(modAndId);
                }
                line = bufferedReader.readLine();
            }
        }
        catch (IOException e) {
            PotionRing.log.warn("Error reading potionring.txt");
        }
        if (returnColor) {
            return colors;
        }
        return lines;
    }

    public static void registryModdedCustom(IEventBus bus) {
        DeferredRegister IT = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"potionring");
        RegistryObject RING_OF_GROWING = IT.register("ring_of_growing", () -> new PotionRingItemModded("sizeshiftingpotions", "growing"));
        RegistryObject RING_OF_SHRINKING = IT.register("ring_of_shrinking", () -> new PotionRingItemModded("sizeshiftingpotions", "shrinking"));
        RegistryObject RING_OF_THINNING = IT.register("ring_of_thinning", () -> new PotionRingItemModded("sizeshiftingpotions", "thinning"));
        RegistryObject RING_OF_WIDENING = IT.register("ring_of_widening", () -> new PotionRingItemModded("sizeshiftingpotions", "widening"));
        List<String> list = PRItemsRegistry.createNewFileOrLearn(false);
        if (!list.isEmpty()) {
            for (String s : list) {
                String[] parts = s.split(":");
                if (parts.length != 2) continue;
                String mod = parts[0];
                String id = parts[1];
                RegistryObject registryObject = IT.register("ring_of_" + id, () -> new PotionRingItemModded(mod, id));
            }
        }
        IT.register(bus);
    }
}

