/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.potionring.item;

import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class PotionRingItemModded
extends Item
implements ICurioItem {
    private final String mod;
    private final String name;

    public PotionRingItemModded(String mod, String name) {
        super(new Item.Properties().m_41487_(1));
        this.mod = mod;
        this.name = name;
    }

    public boolean m_6832_(@Nonnull ItemStack p_82789_1_, ItemStack p_82789_2_) {
        return p_82789_2_.m_41720_() == Items.f_42417_;
    }

    public boolean isRepairable(@Nonnull ItemStack stack) {
        return true;
    }

    public boolean m_5812_(@Nonnull ItemStack p_77636_1_) {
        return false;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        MobEffect eff = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(ResourceLocation.fromNamespaceAndPath((String)this.mod, (String)this.name));
        if (eff != null) {
            this.reloadEffect(slotContext.entity(), eff);
        }
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        MobEffect eff = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(ResourceLocation.fromNamespaceAndPath((String)this.mod, (String)this.name));
        if (eff != null) {
            this.AddEffect(slotContext.entity(), eff);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        MobEffect eff = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(ResourceLocation.fromNamespaceAndPath((String)this.mod, (String)this.name));
        if (eff != null) {
            this.DeleteEffect(slotContext.entity(), eff);
        }
    }

    private void AddEffect(LivingEntity livingEntity, MobEffect mbEff) {
        if (CuriosApi.getCuriosInventory((LivingEntity)livingEntity).resolve().isPresent()) {
            MobEffectInstance effectInstance = new MobEffectInstance(mbEff, 240, ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)livingEntity).resolve().get()).findCurios((Item)this).size() - 1, true, true);
            livingEntity.m_7292_(effectInstance);
        }
    }

    private void reloadEffect(LivingEntity livingEntity, MobEffect mbEff) {
        int baseDuration = 240;
        int minDuration = 100;
        if (livingEntity.m_21023_(mbEff)) {
            MobEffectInstance currentEffect = livingEntity.m_21124_(mbEff);
            if (currentEffect != null) {
                int ringAmplifier = 0;
                if (CuriosApi.getCuriosInventory((LivingEntity)livingEntity).resolve().isPresent()) {
                    ringAmplifier = ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)livingEntity).resolve().get()).findCurios((Item)this).size() - 1;
                }
                if (currentEffect.m_19564_() > ringAmplifier) {
                    return;
                }
                if (currentEffect.m_19557_() <= minDuration) {
                    currentEffect.f_19503_ = baseDuration;
                    livingEntity.m_7292_(currentEffect);
                }
            }
        } else if (!livingEntity.m_21023_(mbEff) && CuriosApi.getCuriosInventory((LivingEntity)livingEntity).resolve().isPresent() && ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)livingEntity).resolve().get()).findCurios((Item)this).size() == 1) {
            MobEffectInstance eff = new MobEffectInstance(mbEff, baseDuration, ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)livingEntity).resolve().get()).findCurios((Item)this).size() - 1, true, true);
            livingEntity.m_7292_(eff);
        }
    }

    private void DeleteEffect(LivingEntity livingEntity, MobEffect mbEff) {
        MobEffectInstance currentEffect = livingEntity.m_21124_(mbEff);
        if (currentEffect != null && livingEntity.m_21023_(mbEff) && currentEffect.m_19564_() > 0) {
            --currentEffect.f_19504_;
            livingEntity.m_21195_(mbEff);
            livingEntity.m_7292_(currentEffect);
        }
    }
}

