/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.potionring.item;

import javax.annotation.Nonnull;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class PotionRingItem
extends Item
implements ICurioItem {
    public final MobEffect eff;

    public PotionRingItem(MobEffect effect) {
        super(new Item.Properties().stacksTo(1));
        this.eff = effect;
    }

    public boolean isValidRepairItem(@Nonnull ItemStack p_82789_1_, ItemStack p_82789_2_) {
        return p_82789_2_.getItem() == Items.GOLD_INGOT;
    }

    public boolean isRepairable(@Nonnull ItemStack stack) {
        return true;
    }

    public boolean isFoil(@Nonnull ItemStack p_77636_1_) {
        return false;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (this.eff != null) {
            this.reloadMobEffect(slotContext.entity(), this.eff);
        }
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        if (this.eff != null) {
            this.AddMobEffect(slotContext.entity(), this.eff);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (this.eff != null) {
            this.DeleteMobEffect(slotContext.entity(), this.eff);
        }
    }

    private void AddMobEffect(LivingEntity livingEntity, MobEffect mbEff) {
        if (CuriosApi.getCuriosInventory((LivingEntity)livingEntity).isPresent()) {
            MobEffectInstance effectInstance = new MobEffectInstance(mbEff, mbEff == MobEffects.NIGHT_VISION ? 500 : 240, ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)livingEntity).get()).findCurios((Item)this).size() - 1, true, true);
            livingEntity.addEffect(effectInstance);
        }
    }

    private void reloadMobEffect(LivingEntity livingEntity, MobEffect mbEff) {
        int minDuration;
        int baseDuration = mbEff == MobEffects.NIGHT_VISION ? 500 : 240;
        int n = minDuration = mbEff == MobEffects.NIGHT_VISION ? 240 : 100;
        if (livingEntity.hasEffect(mbEff)) {
            MobEffectInstance currentMobEffect = livingEntity.getEffect(mbEff);
            if (currentMobEffect != null) {
                int ringAmplifier = 0;
                if (CuriosApi.getCuriosInventory((LivingEntity)livingEntity).isPresent()) {
                    ringAmplifier = ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)livingEntity).get()).findCurios((Item)this).size() - 1;
                }
                if (currentMobEffect.getAmplifier() > ringAmplifier) {
                    return;
                }
                if (currentMobEffect.getDuration() <= minDuration) {
                    currentMobEffect.duration = baseDuration;
                    livingEntity.addEffect(currentMobEffect);
                }
            }
        } else if (!livingEntity.hasEffect(mbEff) && CuriosApi.getCuriosInventory((LivingEntity)livingEntity).isPresent() && ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)livingEntity).get()).findCurios((Item)this).size() == 1) {
            MobEffectInstance eff = new MobEffectInstance(mbEff, baseDuration, ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)livingEntity).get()).findCurios((Item)this).size() - 1, true, true);
            livingEntity.addEffect(eff);
        }
    }

    private void DeleteMobEffect(LivingEntity livingEntity, MobEffect mbEff) {
        MobEffectInstance currentMobEffect = livingEntity.getEffect(mbEff);
        if (currentMobEffect != null && livingEntity.hasEffect(mbEff) && currentMobEffect.getAmplifier() > 0) {
            --currentMobEffect.amplifier;
            livingEntity.removeEffect(mbEff);
            livingEntity.addEffect(currentMobEffect);
        }
    }
}

