package dev.zelo.renderscale;

import com.mojang.blaze3d.platform.GlStateManager;
import dev.zelo.renderscale.config.RenderScaleConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import net.minecraft.class_1041;
import net.minecraft.class_276;
import net.minecraft.class_279;
import net.minecraft.class_310;
import net.minecraft.class_6364;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

import java.util.HashSet;
import java.util.Set;

// This class is part of the common project meaning it is shared between all supported loaders. Code written here can only
// import and access the vanilla codebase, libraries used by vanilla, and optionally third party libraries that provide
// common compatible binaries. This means common code can not directly use loader specific concepts such as Forge events
// however it will be compatible with all supported mod loaders.
public class CommonClass {
    private static final class_310 client = class_310.method_1551();
    @Nullable
    private class_276 renderTarget;

    @Nullable
    private class_276 clientRenderTarget;

    private Set<class_276> minecraftRenderTargets;

    private static CommonClass instance;
    private boolean shouldScale = false;
    public boolean hasRun = false;

    public static final ConfigHolder<RenderScaleConfig> CONFIG = RenderScaleConfig.init();

    public static void init() {
        instance = new CommonClass();
    }

    public static CommonClass getInstance() {
        return instance;
    }

    public static RenderScaleConfig getConfig() {
        return CONFIG.getConfig();
    }

    public void initMinecraftRenderTargets() {
        if (minecraftRenderTargets != null) {
            minecraftRenderTargets.clear();
        } else {
            minecraftRenderTargets = new HashSet<>();
        }

        minecraftRenderTargets.add(client.field_1769.method_22990());
        minecraftRenderTargets.remove(null);
    }

    public void onResolutionChanged() {
        if (getWindow() == null) return;
        Constants.LOG.info("Size changed to {}x{} {}x{} {}x{}",
                getWindow().method_4489(), getWindow().method_4506(),
                getWindow().method_4480(), getWindow().method_4507(),
                getWindow().method_4486(), getWindow().method_4502());

        class_1041 window = client.method_22683();
        updateRenderTargetSize();

        // TODO: idk why but we gotta do this to make the glow stay... investigate more...
        client.field_1769.method_3242(window.method_4486(), window.method_4502());
    }

    public void updateRenderTargetSize() {
        if (renderTarget == null) return;

        resize(renderTarget);
        resize(client.field_1769.method_22990());
        resizeMinecraftRenderTargetSize();
    }

    public void resizeMinecraftRenderTargetSize() {
        initMinecraftRenderTargets();
        minecraftRenderTargets.forEach(this::resize);
        this.resize(client.field_1769.field_4059);
    }

    public void setShouldScale(boolean shouldScale) {
        if (this.shouldScale == shouldScale) return;

        class_1041 window = client.method_22683();
        if (renderTarget == null) {
            this.shouldScale = true;
            renderTarget = new class_6364(window.method_4489(), window.method_4506());
        }

        this.shouldScale = shouldScale;

        if (shouldScale) {
            clientRenderTarget = client.method_1522();

            setClientRenderTarget(renderTarget);
            renderTarget.method_1235(true);
        } else {
            setClientRenderTarget(clientRenderTarget);
            client.method_1522().method_1235(true);

            // TODO: Support fabulous graphics. Right now disableBlend = true shows the other passes but messes up the main target
            renderTarget.method_22594(window.method_4489(), window.method_4506(), class_310.field_1703);
        }
    }

    public double getCurrentScaleFactor() {
        return shouldScale ? CommonClass.getConfig().getScale() : 1;
    }

    private class_1041 getWindow() {
        return client.method_22683();
    }

    private void setClientRenderTarget(class_276 renderTarget) {
        client.field_1689 = renderTarget;
    }

    public void resize(@Nullable class_276 renderTarget) {
        if (renderTarget == null) return;

        boolean prev = shouldScale;
        shouldScale = true;

        class_1041 window = client.method_22683();
        renderTarget.method_1234(window.method_4489(), window.method_4506(), class_310.field_1703);

        shouldScale = prev;
    }

    public void resize(@Nullable class_279 postChain) {
        if (postChain == null) return;

        boolean prev = shouldScale;
        shouldScale = true;

        class_1041 window = client.method_22683();

        for (class_276 target : postChain.field_1496) {
            target.method_1234(window.method_4489(), window.method_4506(), class_310.field_1703);
        }

        shouldScale = prev;
    }
}
