package dev.zelo.renderscale.mixin;

import dev.zelo.renderscale.CommonClass;
import net.minecraft.class_276;
import net.minecraft.class_279;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_279.class)
public class MixinPostChain {
    @Shadow private Matrix4f shaderOrthoMatrix;
    @Shadow @Final private String name;

    @Unique
    private double renderScale$inverseScale() {
        return name.equals("minecraft:shaders/post/entity_outline.json") ? 1 / CommonClass.getConfig().getScale() : 1;
    }

    @Redirect(method = "resize", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/pipeline/RenderTarget;resize(IIZ)V"))
    private void a(class_276 instance, int width, int height, boolean clearError) {
        instance.method_1234((int) (width / renderScale$inverseScale()), (int) (height / renderScale$inverseScale()), clearError);
    }

    @Inject(method = "updateOrthoMatrix", at = @At("TAIL"))
    private void onUpdateOrthoMatrix(CallbackInfo ci) {
        this.shaderOrthoMatrix = this.shaderOrthoMatrix.scale((float) renderScale$inverseScale(), (float) renderScale$inverseScale(), 1.0F);
    }

    // TODO: @ModifyArgs DOES NOT WORK!! WHY?
}
