/*
 * Decompiled with CFR 0.152.
 */
package dev.zelo.renderscale;

import dev.zelo.renderscale.Constants;
import dev.zelo.renderscale.config.RenderScaleConfig;
import java.util.HashSet;
import java.util.Set;
import me.shedaniel.autoconfig.ConfigHolder;
import net.minecraft.class_1041;
import net.minecraft.class_276;
import net.minecraft.class_279;
import net.minecraft.class_310;
import net.minecraft.class_6364;
import org.jetbrains.annotations.Nullable;

public class CommonClass {
    private static final class_310 client = class_310.method_1551();
    @Nullable
    private class_276 renderTarget;
    @Nullable
    private class_276 clientRenderTarget;
    private Set<class_276> minecraftRenderTargets;
    private static CommonClass instance;
    private boolean shouldScale = false;
    public boolean hasRun = false;
    public static final ConfigHolder<RenderScaleConfig> CONFIG;

    public static void init() {
        instance = new CommonClass();
    }

    public static CommonClass getInstance() {
        return instance;
    }

    public static RenderScaleConfig getConfig() {
        return (RenderScaleConfig)CONFIG.getConfig();
    }

    public void initMinecraftRenderTargets() {
        if (this.minecraftRenderTargets != null) {
            this.minecraftRenderTargets.clear();
        } else {
            this.minecraftRenderTargets = new HashSet<class_276>();
        }
        this.minecraftRenderTargets.add(CommonClass.client.field_1769.method_22990());
        this.minecraftRenderTargets.remove(null);
    }

    public void onResolutionChanged() {
        if (this.getWindow() == null) {
            return;
        }
        Constants.LOG.info("Size changed to {}x{} {}x{} {}x{}", new Object[]{this.getWindow().method_4489(), this.getWindow().method_4506(), this.getWindow().method_4480(), this.getWindow().method_4507(), this.getWindow().method_4486(), this.getWindow().method_4502()});
        class_1041 window = client.method_22683();
        this.updateRenderTargetSize();
        CommonClass.client.field_1769.method_3242(window.method_4486(), window.method_4502());
    }

    public void updateRenderTargetSize() {
        if (this.renderTarget == null) {
            return;
        }
        this.resize(this.renderTarget);
        this.resize(CommonClass.client.field_1769.method_22990());
        this.resizeMinecraftRenderTargetSize();
    }

    public void resizeMinecraftRenderTargetSize() {
        this.initMinecraftRenderTargets();
        this.minecraftRenderTargets.forEach(this::resize);
        this.resize(CommonClass.client.field_1769.field_4059);
    }

    public void setShouldScale(boolean shouldScale) {
        if (this.shouldScale == shouldScale) {
            return;
        }
        class_1041 window = client.method_22683();
        if (this.renderTarget == null) {
            this.shouldScale = true;
            this.renderTarget = new class_6364(window.method_4489(), window.method_4506());
        }
        this.shouldScale = shouldScale;
        if (shouldScale) {
            this.clientRenderTarget = client.method_1522();
            this.setClientRenderTarget(this.renderTarget);
            this.renderTarget.method_1235(true);
        } else {
            this.setClientRenderTarget(this.clientRenderTarget);
            client.method_1522().method_1235(true);
            this.renderTarget.method_22594(window.method_4489(), window.method_4506(), class_310.field_1703);
        }
    }

    public double getCurrentScaleFactor() {
        return this.shouldScale ? (double)CommonClass.getConfig().getScale() : 1.0;
    }

    private class_1041 getWindow() {
        return client.method_22683();
    }

    private void setClientRenderTarget(class_276 renderTarget) {
        CommonClass.client.field_1689 = renderTarget;
    }

    public void resize(@Nullable class_276 renderTarget) {
        if (renderTarget == null) {
            return;
        }
        boolean prev = this.shouldScale;
        this.shouldScale = true;
        class_1041 window = client.method_22683();
        renderTarget.method_1234(window.method_4489(), window.method_4506(), class_310.field_1703);
        this.shouldScale = prev;
    }

    public void resize(@Nullable class_279 postChain) {
        if (postChain == null) {
            return;
        }
        boolean prev = this.shouldScale;
        this.shouldScale = true;
        class_1041 window = client.method_22683();
        for (class_276 target : postChain.field_1496) {
            target.method_1234(window.method_4489(), window.method_4506(), class_310.field_1703);
        }
        this.shouldScale = prev;
    }

    static {
        CONFIG = RenderScaleConfig.init();
    }
}

