/*
 * Decompiled with CFR 0.152.
 */
package dev.zelo.renderscale;

import com.mojang.blaze3d.pipeline.MainTarget;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import dev.zelo.renderscale.Constants;
import dev.zelo.renderscale.config.RenderScaleConfig;
import java.util.HashSet;
import java.util.Set;
import me.shedaniel.autoconfig.ConfigHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import org.jetbrains.annotations.Nullable;

public class CommonClass {
    private static final Minecraft client = Minecraft.getInstance();
    @Nullable
    private RenderTarget renderTarget;
    @Nullable
    private RenderTarget clientRenderTarget;
    private Set<RenderTarget> minecraftRenderTargets;
    private static CommonClass instance;
    private boolean shouldScale = false;
    public boolean hasRun = false;
    public static final ConfigHolder<RenderScaleConfig> CONFIG;

    public static void init() {
        instance = new CommonClass();
    }

    public static CommonClass getInstance() {
        return instance;
    }

    public static RenderScaleConfig getConfig() {
        return (RenderScaleConfig)CONFIG.getConfig();
    }

    public void initMinecraftRenderTargets() {
        if (this.minecraftRenderTargets != null) {
            this.minecraftRenderTargets.clear();
        } else {
            this.minecraftRenderTargets = new HashSet<RenderTarget>();
        }
        this.minecraftRenderTargets.add(CommonClass.client.levelRenderer.entityTarget());
        this.minecraftRenderTargets.remove(null);
    }

    public void onResolutionChanged() {
        if (this.getWindow() == null) {
            return;
        }
        Constants.LOG.info("Size changed to {}x{} {}x{} {}x{}", new Object[]{this.getWindow().getWidth(), this.getWindow().getHeight(), this.getWindow().getScreenWidth(), this.getWindow().getScreenHeight(), this.getWindow().getGuiScaledWidth(), this.getWindow().getGuiScaledHeight()});
        Window window = client.getWindow();
        this.updateRenderTargetSize();
        CommonClass.client.levelRenderer.resize(window.getGuiScaledWidth(), window.getGuiScaledHeight());
    }

    public void updateRenderTargetSize() {
        if (this.renderTarget == null) {
            return;
        }
        this.resize(this.renderTarget);
        this.resize(CommonClass.client.levelRenderer.entityTarget());
        this.resizeMinecraftRenderTargetSize();
    }

    public void resizeMinecraftRenderTargetSize() {
        this.initMinecraftRenderTargets();
        this.minecraftRenderTargets.forEach(this::resize);
        this.resize(CommonClass.client.levelRenderer.entityEffect);
    }

    public void setShouldScale(boolean shouldScale) {
        if (this.shouldScale == shouldScale) {
            return;
        }
        Window window = client.getWindow();
        if (this.renderTarget == null) {
            this.shouldScale = true;
            this.renderTarget = new MainTarget(window.getWidth(), window.getHeight());
        }
        this.shouldScale = shouldScale;
        if (shouldScale) {
            this.clientRenderTarget = client.getMainRenderTarget();
            this.setClientRenderTarget(this.renderTarget);
            this.renderTarget.bindWrite(true);
        } else {
            this.setClientRenderTarget(this.clientRenderTarget);
            client.getMainRenderTarget().bindWrite(true);
            this.renderTarget.blitToScreen(window.getWidth(), window.getHeight(), Minecraft.ON_OSX);
        }
    }

    public double getCurrentScaleFactor() {
        return this.shouldScale ? (double)CommonClass.getConfig().getScale() : 1.0;
    }

    private Window getWindow() {
        return client.getWindow();
    }

    private void setClientRenderTarget(RenderTarget renderTarget) {
        CommonClass.client.mainRenderTarget = renderTarget;
    }

    public void resize(@Nullable RenderTarget renderTarget) {
        if (renderTarget == null) {
            return;
        }
        boolean prev = this.shouldScale;
        this.shouldScale = true;
        Window window = client.getWindow();
        renderTarget.resize(window.getWidth(), window.getHeight(), Minecraft.ON_OSX);
        this.shouldScale = prev;
    }

    public void resize(@Nullable PostChain postChain) {
        if (postChain == null) {
            return;
        }
        boolean prev = this.shouldScale;
        this.shouldScale = true;
        Window window = client.getWindow();
        for (RenderTarget target : postChain.fullSizedTargets) {
            target.resize(window.getWidth(), window.getHeight(), Minecraft.ON_OSX);
        }
        this.shouldScale = prev;
    }

    static {
        CONFIG = RenderScaleConfig.init();
    }
}

