/*
 * Decompiled with CFR 0.152.
 */
package dev.zelo.renderscale.mixin;

import dev.zelo.renderscale.CommonClass;
import net.minecraft.client.renderer.GameRenderer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class MixinGameRenderer {
    @Unique
    private boolean waitingForResolutionChange = false;
    @Unique
    private int waitFrameCounter = 0;

    @Inject(at={@At(value="HEAD")}, method={"renderLevel"})
    private void onRenderWorldBegin(CallbackInfo callbackInfo) {
        if (!CommonClass.getInstance().hasRun) {
            CommonClass.getInstance().hasRun = true;
            this.waitingForResolutionChange = true;
        }
        if (this.waitingForResolutionChange) {
            ++this.waitFrameCounter;
            if (this.waitFrameCounter >= 5) {
                this.waitingForResolutionChange = false;
                CommonClass.getInstance().onResolutionChanged();
            }
        }
        CommonClass.getInstance().setShouldScale(true);
    }

    @Inject(at={@At(value="RETURN")}, method={"renderLevel"})
    private void onRenderWorldEnd(CallbackInfo callbackInfo) {
        CommonClass.getInstance().setShouldScale(false);
    }
}

