package dev.zelo.renderscale;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import dev.zelo.renderscale.accessors.GICommandEncoderThing;
import dev.zelo.renderscale.config.RenderScaleConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import net.minecraft.class_1041;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_6367;
import org.jetbrains.annotations.Nullable;

// This class is part of the common project meaning it is shared between all supported loaders. Code written here can only
// import and access the vanilla codebase, libraries used by vanilla, and optionally third party libraries that provide
// common compatible binaries. This means common code can not directly use loader specific concepts such as Forge events
// however it will be compatible with all supported mod loaders.
public class CommonClass {
    private static class_310 client = class_310.method_1551();

    // This is RenderScale's renderTarget
    @Nullable
    public class_276 renderTarget;

    // This is Minecraft's renderTarget
    @Nullable
    public class_276 clientRenderTarget;

    private static CommonClass instance;
    private boolean shouldScale = false;
    public boolean hasRun = false;

    public static final ConfigHolder<RenderScaleConfig> CONFIG = RenderScaleConfig.init();

    // Fabric
    public static void init() {
        instance = new CommonClass();
    }

    // NeoForge made it so that the mod loads before Minecraft (but not fabric...), so this is needed to get the "actual" Minecraft instance
    public static void init(class_310 client) {
        instance = new CommonClass();
        CommonClass.client = client;
    }

    public static CommonClass getInstance() {
        return instance;
    }

    public static RenderScaleConfig getConfig() {
        return CONFIG.getConfig();
    }

    public void onResolutionChanged() {
        if (getWindow() == null) return;
        Constants.LOG.info("Size changed to {}x{} {}x{} {}x{}",
                getWindow().method_4489(), getWindow().method_4506(),
                getWindow().method_4480(), getWindow().method_4507(),
                getWindow().method_4486(), getWindow().method_4502());

        resizeRenderTarget();
    }

    public void setClientRenderTarget(class_276 renderTarget) {
        client.field_1689 = renderTarget;
    }

    public void setShouldScale(boolean shouldScale) {
        class_1041 window = client.method_22683();
        int width = window.method_4489();
        int height = window.method_4506();

        int scaledWidth = Math.clamp(width, 1, 65536);
        int scaledHeight = Math.clamp(height, 1, 65536);

        if (renderTarget == null) {
            renderTarget = new class_6367("RenderScale", scaledWidth, scaledHeight, true);
        }

        if (clientRenderTarget == null) {
            clientRenderTarget = client.method_1522();
        }

        if (shouldScale) {
            setClientRenderTarget(renderTarget);
        } else {
            try {
                setClientRenderTarget(clientRenderTarget);

//                ((GICommandEncoderThing) RenderSystem.getDevice().createCommandEncoder()).copyTextureToTexture(
//                ((GICommandEncoderThing) RenderSystem.getDevice().createCommandEncoder()).presentTexture(
//                        (GpuTextureView)  renderTarget.getColorTexture());

                ((GICommandEncoderThing) RenderSystem.getDevice().createCommandEncoder()).renderScale$copyAndResizeTexture(
                        renderTarget.method_30277(), clientRenderTarget.method_30277(),
                        0, 0, 0, 0, 0,
                        renderTarget.field_1482, renderTarget.field_1481,
                        width, height, false
                );
                ((GICommandEncoderThing) RenderSystem.getDevice().createCommandEncoder()).renderScale$copyAndResizeTexture(
                        renderTarget.method_30278(), clientRenderTarget.method_30278(),
                        0, 0, 0, 0, 0,
                        renderTarget.field_1482, renderTarget.field_1481,
                        width, height, true
                );
            } catch (Exception e) {
                Constants.LOG.error("Error copying texture", e);
            }
        }
    }

    // Takes into account shouldScale
    public double getCurrentScaleFactor() {
        return shouldScale ? getConfig().getScale() : 1;
    }

    @Nullable
    private class_1041 getWindow() {
        return client.method_22683();
    }

    public void resizeRenderTarget() {
        if (renderTarget == null) return;

        boolean prev = shouldScale;
        shouldScale = true;

        class_1041 window = client.method_22683();
        int width = window.method_4489();
        int height = window.method_4506();

        int scaledWidth = Math.clamp(width, 1, 65536);
        int scaledHeight = Math.clamp(height, 1, 65536);
        renderTarget.method_1234(scaledWidth, scaledHeight);

        shouldScale = prev;
    }
}
