/*
 * Decompiled with CFR 0.152.
 */
package dev.zelo.renderscale;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.zelo.renderscale.Constants;
import dev.zelo.renderscale.accessors.GICommandEncoderThing;
import dev.zelo.renderscale.config.RenderScaleConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import net.minecraft.class_1041;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_6367;
import org.jetbrains.annotations.Nullable;

public class CommonClass {
    private static class_310 client = class_310.method_1551();
    @Nullable
    public class_276 renderTarget;
    @Nullable
    public class_276 clientRenderTarget;
    private static CommonClass instance;
    private boolean shouldScale = false;
    public boolean hasRun = false;
    public static final ConfigHolder<RenderScaleConfig> CONFIG;

    public static void init() {
        instance = new CommonClass();
    }

    public static void init(class_310 client) {
        instance = new CommonClass();
        CommonClass.client = client;
    }

    public static CommonClass getInstance() {
        return instance;
    }

    public static RenderScaleConfig getConfig() {
        return (RenderScaleConfig)CONFIG.getConfig();
    }

    public void onResolutionChanged() {
        if (this.getWindow() == null) {
            return;
        }
        Constants.LOG.info("Size changed to {}x{} {}x{} {}x{}", new Object[]{this.getWindow().method_4489(), this.getWindow().method_4506(), this.getWindow().method_4480(), this.getWindow().method_4507(), this.getWindow().method_4486(), this.getWindow().method_4502()});
        this.resizeRenderTarget();
    }

    public void setClientRenderTarget(class_276 renderTarget) {
        CommonClass.client.field_1689 = renderTarget;
    }

    public void setShouldScale(boolean shouldScale) {
        class_1041 window = client.method_22683();
        int width = window.method_4489();
        int height = window.method_4506();
        int scaledWidth = Math.clamp((long)width, 1, 65536);
        int scaledHeight = Math.clamp((long)height, 1, 65536);
        if (this.renderTarget == null) {
            this.renderTarget = new class_6367("RenderScale", scaledWidth, scaledHeight, true);
        }
        if (this.clientRenderTarget == null) {
            this.clientRenderTarget = client.method_1522();
        }
        if (shouldScale) {
            this.setClientRenderTarget(this.renderTarget);
        } else {
            try {
                this.setClientRenderTarget(this.clientRenderTarget);
                ((GICommandEncoderThing)RenderSystem.getDevice().createCommandEncoder()).renderScale$copyAndResizeTexture(this.renderTarget.method_30277(), this.clientRenderTarget.method_30277(), 0, 0, 0, 0, 0, this.renderTarget.field_1482, this.renderTarget.field_1481, width, height, false);
                ((GICommandEncoderThing)RenderSystem.getDevice().createCommandEncoder()).renderScale$copyAndResizeTexture(this.renderTarget.method_30278(), this.clientRenderTarget.method_30278(), 0, 0, 0, 0, 0, this.renderTarget.field_1482, this.renderTarget.field_1481, width, height, true);
            }
            catch (Exception e) {
                Constants.LOG.error("Error copying texture", (Throwable)e);
            }
        }
    }

    public double getCurrentScaleFactor() {
        return this.shouldScale ? (double)CommonClass.getConfig().getScale() : 1.0;
    }

    @Nullable
    private class_1041 getWindow() {
        return client.method_22683();
    }

    public void resizeRenderTarget() {
        if (this.renderTarget == null) {
            return;
        }
        boolean prev = this.shouldScale;
        this.shouldScale = true;
        class_1041 window = client.method_22683();
        int width = window.method_4489();
        int height = window.method_4506();
        int scaledWidth = Math.clamp((long)width, 1, 65536);
        int scaledHeight = Math.clamp((long)height, 1, 65536);
        this.renderTarget.method_1234(scaledWidth, scaledHeight);
        this.shouldScale = prev;
    }

    static {
        CONFIG = RenderScaleConfig.init();
    }
}

