/*
 * Decompiled with CFR 0.152.
 */
package dev.zelo.renderscale.config;

import dev.zelo.renderscale.CommonClass;
import dev.zelo.renderscale.compat.iris.IrisCompatibility;
import dev.zelo.renderscale.platform.Services;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.irisshaders.iris.api.v0.IrisApi;

@Config(name="renderscale")
public class RenderScaleConfig
implements ConfigData {
    public float scale = 1.0f;
    public boolean forceLinear = false;
    @ConfigEntry.Category(value="iris")
    @ConfigEntry.Gui.Tooltip
    public float irisScale = -1.0f;

    public static ConfigHolder<RenderScaleConfig> init() {
        ConfigHolder holder = AutoConfig.register(RenderScaleConfig.class, JanksonConfigSerializer::new);
        holder.registerSaveListener((manager, data) -> {
            CommonClass.getInstance().onResolutionChanged();
            IrisCompatibility.reloadShaders();
            return null;
        });
        return holder;
    }

    public float getScale() {
        if (Services.PLATFORM.isModLoaded("iris")) {
            if (IrisApi.getInstance().isShaderPackInUse() && this.irisScale > 0.0f) {
                return this.irisScale;
            }
            return this.scale;
        }
        return this.scale;
    }

    public boolean getFilter() {
        return this.forceLinear || (double)this.getScale() > 1.0;
    }
}

