/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.usefulfood.block.init;

import com.mojang.serialization.MapCodec;
import com.skniro.usefulfood.block.UsefulFoodJamBlocks;
import com.skniro.usefulfood.block.init.JamJarBlock;
import com.skniro.usefulfood.item.UsefulFoodItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GlassJarBlock
extends HorizontalDirectionalBlock {
    private static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)9.5, (double)11.0);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final MapCodec<GlassJarBlock> CODEC = GlassJarBlock.simpleCodec(GlassJarBlock::new);

    public GlassJarBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    protected MapCodec<GlassJarBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.getItemInHand(hand);
        if (heldItem.is((Item)UsefulFoodItems.MelonJam.get())) {
            this.replaceWith(world, pos, (BlockState)UsefulFoodJamBlocks.Melon_JAM_JAR.get().defaultBlockState().setValue((Property)JamJarBlock.JAM_STAGE, (Comparable)Integer.valueOf(1)));
            if (!player.isCreative()) {
                heldItem.shrink(1);
            }
            world.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        if (heldItem.is((Item)UsefulFoodItems.AppleJam.get())) {
            this.replaceWith(world, pos, (BlockState)UsefulFoodJamBlocks.Apple_JAM_JAR.get().defaultBlockState().setValue((Property)JamJarBlock.JAM_STAGE, (Comparable)Integer.valueOf(1)));
            if (!player.isCreative()) {
                heldItem.shrink(1);
            }
            world.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        if (heldItem.is(UsefulFoodItems.Glow_Berries_Jam.get())) {
            this.replaceWith(world, pos, (BlockState)UsefulFoodJamBlocks.Glow_Berries_JAM_JAR.get().defaultBlockState().setValue((Property)JamJarBlock.JAM_STAGE, (Comparable)Integer.valueOf(1)));
            if (!player.isCreative()) {
                heldItem.shrink(1);
            }
            world.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        if (heldItem.is(UsefulFoodItems.Sweet_Berries_Jam.get())) {
            this.replaceWith(world, pos, (BlockState)UsefulFoodJamBlocks.Sweet_Berries_JAM_JAR.get().defaultBlockState().setValue((Property)JamJarBlock.JAM_STAGE, (Comparable)Integer.valueOf(1)));
            if (!player.isCreative()) {
                heldItem.shrink(1);
            }
            world.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        if (heldItem.is(UsefulFoodItems.Chorus_Jam.get())) {
            this.replaceWith(world, pos, (BlockState)UsefulFoodJamBlocks.Chorus_JAM_JAR.get().defaultBlockState().setValue((Property)JamJarBlock.JAM_STAGE, (Comparable)Integer.valueOf(1)));
            if (!player.isCreative()) {
                heldItem.shrink(1);
            }
            world.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private void replaceWith(Level world, BlockPos pos, BlockState newState) {
        world.setBlock(pos, newState, 3);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }
}

