/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.usefulfood.item.init;

import com.skniro.usefulfood.item.UsefulFoodItems;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemBottle
extends Item {
    private static final int MAX_USE_TIME = 32;

    public ItemBottle(Item.Properties settings) {
        super(settings);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        Player playerEntity;
        super.finishUsingItem(stack, world, user);
        if (user instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)user;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayerEntity, stack);
            serverPlayerEntity.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (!world.isClientSide && stack.is((Item)UsefulFoodItems.MilkBottle.get())) {
            user.removeAllEffects();
        }
        if (user instanceof Player && !(playerEntity = (Player)user).hasInfiniteMaterials()) {
            ItemStack itemStack = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
            if (!playerEntity.getInventory().add(itemStack)) {
                playerEntity.drop(itemStack, false);
            }
        }
        return stack;
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 32;
    }

    public SoundEvent getEatingSound() {
        return SoundEvents.GENERIC_DRINK;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }
}

