/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.usefulfood.block.init;

import com.skniro.usefulfood.block.init.SpecialCake;
import com.skniro.usefulfood.block.init.candle.CandleMagicCakeBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MagicCakeBlockState
extends SpecialCake {
    public static final int MAX_BITES = 6;
    public static final IntegerProperty BITES = BlockStateProperties.BITES;
    public static final int FULL_CAKE_SIGNAL = MagicCakeBlockState.getOutputSignal(0);
    protected static final float AABB_OFFSET = 1.0f;
    protected static final float AABB_SIZE_PER_BITE = 2.0f;
    protected static final VoxelShape[] BITES_TO_SHAPE = new VoxelShape[]{MagicCakeBlockState.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), MagicCakeBlockState.box((double)3.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), MagicCakeBlockState.box((double)5.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), MagicCakeBlockState.box((double)7.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), MagicCakeBlockState.box((double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), MagicCakeBlockState.box((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), MagicCakeBlockState.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)};

    public MagicCakeBlockState(BlockBehaviour.Properties settings, int foodlevel, float saturation) {
        super(settings, foodlevel, saturation);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BITES, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return BITES_TO_SHAPE[(Integer)state.getValue((Property)BITES)];
    }

    public InteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Block block;
        Item item = itemStack.getItem();
        if (itemStack.is(ItemTags.CANDLES) && (Integer)state.getValue((Property)BITES) == 0 && (block = MagicCakeBlockState.byItem((Item)item)) instanceof CandleBlock) {
            if (!player.isCreative()) {
                itemStack.shrink(1);
            }
            world.playSound(null, pos, SoundEvents.CAKE_ADD_CANDLE, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.setBlockAndUpdate(pos, CandleMagicCakeBlock.getCandleCakeFromCandle(block));
            world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide()) {
            if (MagicCakeBlockState.eat((LevelAccessor)world, pos, state, player).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return MagicCakeBlockState.eat((LevelAccessor)world, pos, state, player);
    }

    public static InteractionResult eat(LevelAccessor world, BlockPos pos, BlockState state, Player player) {
        if (!player.canEat(false)) {
            return InteractionResult.PASS;
        }
        player.awardStat(Stats.EAT_CAKE_SLICE);
        player.getFoodData().eat(foodlevel, saturation);
        player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 200, 3));
        player.addEffect(new MobEffectInstance(MobEffects.RESISTANCE, 2000, 0));
        int i = (Integer)state.getValue((Property)BITES);
        world.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
        if (i < 6) {
            world.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            world.removeBlock(pos, false);
            world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState updateShape(BlockState state, LevelReader levelReader, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource randomSource) {
        if (direction == Direction.DOWN && !state.canSurvive(levelReader, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, levelReader, scheduledTickAccess, pos, direction, neighborPos, neighborState, randomSource);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return world.getBlockState(pos.below()).isSolid();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BITES});
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos, Direction direction) {
        return MagicCakeBlockState.getOutputSignal((Integer)state.getValue((Property)BITES));
    }

    public static int getOutputSignal(int bites) {
        return (7 - bites) * 2;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

