/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.usefulfood.block.init;

import com.skniro.usefulfood.block.UsefulFoodBlocks;
import com.skniro.usefulfood.block.init.SpecialCake;
import com.skniro.usefulfood.block.init.candle.CandleAppleCakeBlock;
import com.skniro.usefulfood.block.init.candle.CandleCaramelCakeBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SpecialCakeBlockState
extends SpecialCake {
    public static final int MAX_BITES = 6;
    public static final IntegerProperty BITES = BlockStateProperties.f_61412_;
    public static final int FULL_CAKE_SIGNAL = SpecialCakeBlockState.getOutputSignal(0);
    protected static final float AABB_OFFSET = 1.0f;
    protected static final float AABB_SIZE_PER_BITE = 2.0f;
    protected static final VoxelShape[] BITES_TO_SHAPE = new VoxelShape[]{SpecialCakeBlockState.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), SpecialCakeBlockState.m_49796_((double)3.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), SpecialCakeBlockState.m_49796_((double)5.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), SpecialCakeBlockState.m_49796_((double)7.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), SpecialCakeBlockState.m_49796_((double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), SpecialCakeBlockState.m_49796_((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), SpecialCakeBlockState.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)};

    public SpecialCakeBlockState(BlockBehaviour.Properties settings, int foodlevel, float saturation) {
        super(settings, foodlevel, saturation);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BITES, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return BITES_TO_SHAPE[(Integer)state.m_61143_((Property)BITES)];
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Block block;
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (state.m_60734_() == Blocks.f_50145_ && itemStack.m_204117_(ItemTags.f_144319_) && (Integer)state.m_61143_((Property)BITES) == 0 && (block = SpecialCakeBlockState.m_49814_((Item)item)) instanceof CandleBlock) {
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            world.m_5594_(null, pos, SoundEvents.f_144090_, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_46597_(pos, CandleCakeBlock.m_152865_((Block)block));
            world.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            return InteractionResult.SUCCESS;
        }
        if (state.m_60734_() == UsefulFoodBlocks.CaramelCake.get() && itemStack.m_204117_(ItemTags.f_144319_) && (Integer)state.m_61143_((Property)BITES) == 0 && (block = SpecialCakeBlockState.m_49814_((Item)item)) instanceof CandleBlock) {
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            world.m_5594_(null, pos, SoundEvents.f_144090_, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_46597_(pos, CandleCaramelCakeBlock.getCandleCakeFromCandle(block));
            world.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            return InteractionResult.SUCCESS;
        }
        if (state.m_60734_() == UsefulFoodBlocks.AppleCake.get() && itemStack.m_204117_(ItemTags.f_144319_) && (Integer)state.m_61143_((Property)BITES) == 0 && (block = SpecialCakeBlockState.m_49814_((Item)item)) instanceof CandleBlock) {
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            world.m_5594_(null, pos, SoundEvents.f_144090_, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_46597_(pos, CandleAppleCakeBlock.getCandleCakeFromCandle(block));
            world.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            return InteractionResult.SUCCESS;
        }
        if (world.f_46443_) {
            if (SpecialCakeBlockState.eat((LevelAccessor)world, pos, state, player).m_19077_()) {
                return InteractionResult.SUCCESS;
            }
            if (itemStack.m_41619_()) {
                return InteractionResult.CONSUME;
            }
        }
        return SpecialCakeBlockState.eat((LevelAccessor)world, pos, state, player);
    }

    public static InteractionResult eat(LevelAccessor world, BlockPos pos, BlockState state, Player player) {
        if (!player.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        player.m_36220_(Stats.f_12942_);
        player.m_36324_().m_38707_(foodlevel, saturation);
        int i = (Integer)state.m_61143_((Property)BITES);
        world.m_142346_((Entity)player, GameEvent.f_157806_, pos);
        if (i < 6) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            world.m_7471_(pos, false);
            world.m_142346_((Entity)player, GameEvent.f_157794_, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.DOWN && !state.m_60710_((LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return world.m_8055_(pos.m_7495_()).m_280296_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BITES});
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return SpecialCakeBlockState.getOutputSignal((Integer)state.m_61143_((Property)BITES));
    }

    public static int getOutputSignal(int bites) {
        return (7 - bites) * 2;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }
}

