/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.usefulfood.block.init.candle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.skniro.usefulfood.block.UsefulFoodCakeBlocks;
import com.skniro.usefulfood.block.init.SpecialCakeBlockState;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CandleChocolateCakeBlock
extends AbstractCandleBlock {
    private static final Map<Block, CandleChocolateCakeBlock> CAKES_TRANSFORM = Maps.newHashMap();
    public static final BooleanProperty LIT;
    protected static final float field_31052 = 1.0f;
    protected static final VoxelShape CAKE_SHAPE;
    protected static final VoxelShape CANDLE_SHAPE;
    protected static final VoxelShape SHAPE;
    private static final Map<Block, CandleCakeBlock> CANDLES_TO_CANDLE_CAKES;
    private static final Iterable<Vec3> PARTICLE_OFFSETS;
    private final Block candle;
    public static final MapCodec<CandleChocolateCakeBlock> CODEC;

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public CandleChocolateCakeBlock(Block candle, BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
        CAKES_TRANSFORM.put(candle, this);
        this.candle = candle;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_42409_) || itemStack.m_150930_(Items.f_42613_)) {
            return InteractionResult.PASS;
        }
        if (!(CandleChocolateCakeBlock.isHittingCandle(hit) && player.m_21120_(hand).m_41619_() && ((Boolean)state.m_61143_((Property)LIT)).booleanValue())) {
            InteractionResult result = SpecialCakeBlockState.eat((LevelAccessor)world, pos, ((Block)UsefulFoodCakeBlocks.ChocolateCake.get()).m_49966_(), player);
            if (result.m_19077_()) {
                CandleCakeBlock.m_49950_((BlockState)state, (Level)world, (BlockPos)pos);
            }
            return result;
        }
        CandleCakeBlock.m_151899_((Player)player, (BlockState)state, (LevelAccessor)world, (BlockPos)pos);
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    private static boolean isHittingCandle(BlockHitResult hitResult) {
        return hitResult.m_82450_().f_82480_ - (double)hitResult.m_82425_().m_123342_() > 0.5;
    }

    public ItemStack m_7397_(LevelReader world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)UsefulFoodCakeBlocks.ChocolateCake.get());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT});
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return direction == Direction.DOWN && !state.m_60710_((LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public static BlockState getCandleCakeFromCandle(Block candle) {
        return CAKES_TRANSFORM.get(candle).m_49966_();
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return world.m_8055_(pos.m_7495_()).m_280296_();
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return SpecialCakeBlockState.FULL_CAKE_SIGNAL;
    }

    public boolean m_142595_(BlockState state) {
        return state.m_204338_(BlockTags.f_144268_, statex -> statex.m_61138_((Property)LIT) && (Boolean)state.m_61143_((Property)LIT) == false);
    }

    protected MapCodec<? extends CandleChocolateCakeBlock> m_304657_() {
        return CODEC;
    }

    protected Iterable<Vec3> m_142199_(BlockState state) {
        return PARTICLE_OFFSETS;
    }

    static {
        CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("candle").forGetter(block -> block.candle), (App)CandleChocolateCakeBlock.m_305607_()).apply((Applicative)instance, CandleChocolateCakeBlock::new));
        LIT = AbstractCandleBlock.f_151895_;
        CAKE_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
        CANDLE_SHAPE = Block.m_49796_((double)7.0, (double)8.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0);
        SHAPE = Shapes.m_83110_((VoxelShape)CAKE_SHAPE, (VoxelShape)CANDLE_SHAPE);
        CANDLES_TO_CANDLE_CAKES = Maps.newHashMap();
        PARTICLE_OFFSETS = ImmutableList.of((Object)new Vec3(0.5, 1.0, 0.5));
    }
}

