/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.usefulfood.block.init;

import com.google.common.collect.BiMap;
import com.mojang.serialization.MapCodec;
import com.skniro.usefulfood.block.init.jam.JamType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class JamJarBlock
extends Block {
    public static final IntegerProperty JAM_STAGE = IntegerProperty.create((String)"jam_stage", (int)1, (int)3);
    public static final MapCodec<JamJarBlock> CODEC = JamJarBlock.simpleCodec(JamJarBlock::new);
    private static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)9.5, (double)11.0);
    public static final Map<JamType, BiMap<Item, Item>> JAM_TYPE_MAPS = new HashMap<JamType, BiMap<Item, Item>>();
    public Supplier<Item> JamItem;
    public Supplier<Block> JamBlock;
    public JamType jamType;

    public JamJarBlock(BlockBehaviour.Properties settings, Supplier<Item> item, Supplier<Block> JamBlock, JamType jamType) {
        super(settings);
        this.JamItem = item;
        this.JamBlock = JamBlock;
        this.jamType = jamType;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)JAM_STAGE, (Comparable)Integer.valueOf(3)));
    }

    public JamJarBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)JAM_STAGE, (Comparable)Integer.valueOf(3)));
    }

    protected MapCodec<JamJarBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{JAM_STAGE});
    }

    public InteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.getItemInHand(hand);
        int stage = (Integer)state.getValue((Property)JAM_STAGE);
        if (heldItem.is(this.JamItem.get()) && stage < 3) {
            world.setBlock(pos, (BlockState)state.setValue((Property)JAM_STAGE, (Comparable)Integer.valueOf(stage + 1)), 3);
            if (!player.isCreative()) {
                heldItem.shrink(1);
            }
            world.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (heldItem.isEmpty() && stage > 0) {
            FoodProperties food = (FoodProperties)this.JamItem.get().components().get(DataComponents.FOOD);
            if (food != null) {
                player.getFoodData().eat(food.nutrition(), food.saturation());
            } else {
                player.getFoodData().eat(2, 0.2f);
            }
            world.playSound((Entity)player, pos, (SoundEvent)SoundEvents.GENERIC_EAT.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
            if (stage > 1) {
                world.setBlock(pos, (BlockState)state.setValue((Property)JAM_STAGE, (Comparable)Integer.valueOf(stage - 1)), 3);
            } else {
                world.setBlock(pos, this.JamBlock.get().defaultBlockState(), 3);
                world.playSound(null, pos, SoundEvents.GLASS_PLACE, SoundSource.BLOCKS, 0.5f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        BiMap<Item, Item> conversions = JAM_TYPE_MAPS.get((Object)this.jamType);
        if (conversions != null && conversions.containsKey((Object)heldItem.getItem())) {
            Item jamVariant = (Item)conversions.get((Object)heldItem.getItem());
            player.setItemInHand(hand, new ItemStack((ItemLike)jamVariant));
            if (stage > 1) {
                world.setBlock(pos, (BlockState)state.setValue((Property)JAM_STAGE, (Comparable)Integer.valueOf(stage - 1)), 3);
            } else {
                world.setBlock(pos, this.JamBlock.get().defaultBlockState(), 3);
                world.playSound(null, pos, SoundEvents.GLASS_PLACE, SoundSource.BLOCKS, 0.5f, 1.2f);
            }
            world.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.PLAYERS, 0.8f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

