/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.usefulfood.block.init;

import com.skniro.usefulfood.block.init.SpecialCake;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class SpecialCakeBlockState
extends SpecialCake {
    public static final int MAX_BITES = 6;
    public static final IntegerProperty BITES = BlockStateProperties.field_208173_Z;
    public static final int FULL_CAKE_SIGNAL = SpecialCakeBlockState.getOutputSignal(0);
    protected static final float AABB_OFFSET = 1.0f;
    protected static final float AABB_SIZE_PER_BITE = 2.0f;
    protected static final VoxelShape[] BITES_TO_SHAPE = new VoxelShape[]{SpecialCakeBlockState.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), SpecialCakeBlockState.func_208617_a((double)3.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), SpecialCakeBlockState.func_208617_a((double)5.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), SpecialCakeBlockState.func_208617_a((double)7.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), SpecialCakeBlockState.func_208617_a((double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), SpecialCakeBlockState.func_208617_a((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), SpecialCakeBlockState.func_208617_a((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)};

    public SpecialCakeBlockState(AbstractBlock.Properties settings, int foodlevel, float saturation) {
        super(settings, foodlevel, saturation);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)BITES, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return BITES_TO_SHAPE[(Integer)state.func_177229_b((Property)BITES)];
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack itemStack = player.func_184586_b(hand);
        Item item = itemStack.func_77973_b();
        if (world.field_72995_K) {
            if (SpecialCakeBlockState.eat((IWorld)world, pos, state, player).func_226246_a_()) {
                return ActionResultType.SUCCESS;
            }
            if (itemStack.func_190926_b()) {
                return ActionResultType.CONSUME;
            }
        }
        return SpecialCakeBlockState.eat((IWorld)world, pos, state, player);
    }

    protected static ActionResultType eat(IWorld world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!player.func_71043_e(false)) {
            return ActionResultType.PASS;
        }
        player.func_195066_a(Stats.field_188076_J);
        player.func_71024_bL().func_75122_a(foodlevel, saturation);
        int i = (Integer)state.func_177229_b((Property)BITES);
        if (i < 6) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            world.func_217377_a(pos, false);
        }
        return ActionResultType.SUCCESS;
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.DOWN && !state.func_196955_c((IWorldReader)world, pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BITES});
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        return SpecialCakeBlockState.getOutputSignal((Integer)state.func_177229_b((Property)BITES));
    }

    public static int getOutputSignal(int bites) {
        return (7 - bites) * 2;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return false;
    }
}

