/*
 * Decompiled with CFR 0.152.
 */
package com.simpleluckyblock;

import com.simpleluckyblock.SimpleLuckyBlockMod;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class LuckyBlock
extends Block {
    public LuckyBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void spawnAfterBreak(BlockState state, ServerLevel level, BlockPos pos, ItemStack tool, boolean dropExperience) {
        super.spawnAfterBreak(state, level, pos, tool, dropExperience);
        level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.PLAYER_LEVELUP, SoundSource.BLOCKS, 1.0f, 1.0f);
        RandomSource random = level.random;
        int luckRoll = random.nextInt(100);
        if (luckRoll < 20) {
            this.unluckyDrops(level, pos, random);
        } else if (luckRoll < 85) {
            this.normalDrops(level, pos, random);
        } else {
            this.veryLuckyDrops(level, pos, random);
        }
    }

    private void unluckyDrops(ServerLevel level, BlockPos pos, RandomSource random) {
        int unluckyType = random.nextInt(5);
        switch (unluckyType) {
            case 0: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.DIRT, random.nextInt(5) + 1));
                break;
            }
            case 1: {
                level.explode(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 2.5f, Level.ExplosionInteraction.BLOCK);
                level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.BLOCKS, 1.0f, 1.0f);
                break;
            }
            case 2: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.ROTTEN_FLESH, random.nextInt(8) + 3));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.SPIDER_EYE, random.nextInt(3) + 1));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.POISONOUS_POTATO, random.nextInt(4) + 2));
                break;
            }
            case 3: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.GRAVEL, random.nextInt(10) + 5));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.COBBLESTONE, random.nextInt(8) + 4));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.SAND, random.nextInt(6) + 3));
                break;
            }
            case 4: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.STICK, random.nextInt(15) + 10));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.DEAD_BUSH, random.nextInt(5) + 2));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.FLINT, random.nextInt(8) + 4));
            }
        }
        level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.VILLAGER_NO, SoundSource.BLOCKS, 1.0f, 0.5f);
    }

    private void normalDrops(ServerLevel level, BlockPos pos, RandomSource random) {
        int dropType = random.nextInt(25);
        switch (dropType) {
            case 0: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.WOODEN_SWORD));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.WOODEN_PICKAXE));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.WOODEN_AXE));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.WOODEN_SHOVEL));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.WOODEN_HOE));
                break;
            }
            case 1: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.GOLDEN_SWORD));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.GOLDEN_PICKAXE));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.GOLDEN_AXE));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.GOLDEN_SHOVEL));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.GOLDEN_HOE));
                break;
            }
            case 2: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.STONE_SWORD));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.STONE_PICKAXE));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.STONE_AXE));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.STONE_SHOVEL));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.STONE_HOE));
                break;
            }
            case 3: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.LEATHER_HELMET));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.LEATHER_CHESTPLATE));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.LEATHER_LEGGINGS));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.LEATHER_BOOTS));
                break;
            }
            case 4: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.GOLDEN_HELMET));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.GOLDEN_CHESTPLATE));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.GOLDEN_LEGGINGS));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.GOLDEN_BOOTS));
                break;
            }
            case 5: {
                ItemStack[] ironArmor = new ItemStack[]{new ItemStack((ItemLike)Items.IRON_HELMET), new ItemStack((ItemLike)Items.IRON_CHESTPLATE), new ItemStack((ItemLike)Items.IRON_LEGGINGS), new ItemStack((ItemLike)Items.IRON_BOOTS)};
                int pieces = random.nextInt(2) + 2;
                for (int i = 0; i < pieces; ++i) {
                    this.dropItem((Level)level, pos, ironArmor[random.nextInt(ironArmor.length)]);
                }
                break;
            }
            case 6: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.SPONGE));
                break;
            }
            case 7: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.ENDER_CHEST, 2));
                break;
            }
            case 8: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.ENDER_PEARL, random.nextInt(3) + 2));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.ENDER_EYE, random.nextInt(2) + 1));
                break;
            }
            case 9: {
                ItemStack clock = new ItemStack((ItemLike)Items.CLOCK);
                clock.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"You're wasting your time"));
                this.dropItem((Level)level, pos, clock);
                break;
            }
            case 10: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.LAVA_BUCKET, random.nextInt(3) + 2));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.WATER_BUCKET, random.nextInt(3) + 2));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.MILK_BUCKET, random.nextInt(3) + 2));
                break;
            }
            case 11: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.WHITE_DYE, random.nextInt(8) + 4));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.ORANGE_DYE, random.nextInt(8) + 4));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.MAGENTA_DYE, random.nextInt(8) + 4));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.LIGHT_BLUE_DYE, random.nextInt(8) + 4));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.YELLOW_DYE, random.nextInt(8) + 4));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.LIME_DYE, random.nextInt(8) + 4));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.PINK_DYE, random.nextInt(8) + 4));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.GRAY_DYE, random.nextInt(8) + 4));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.LIGHT_GRAY_DYE, random.nextInt(8) + 4));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.CYAN_DYE, random.nextInt(8) + 4));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.PURPLE_DYE, random.nextInt(8) + 4));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.BLUE_DYE, random.nextInt(8) + 4));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.BROWN_DYE, random.nextInt(8) + 4));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.GREEN_DYE, random.nextInt(8) + 4));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.RED_DYE, random.nextInt(8) + 4));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.BLACK_DYE, random.nextInt(8) + 4));
                break;
            }
            case 12: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.PUMPKIN, random.nextInt(5) + 3));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.JACK_O_LANTERN, random.nextInt(3) + 2));
                break;
            }
            case 13: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.TNT, random.nextInt(4) + 2));
                break;
            }
            case 14: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.SADDLE, 2));
                break;
            }
            case 15: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.ROTTEN_FLESH, random.nextInt(10) + 5));
                break;
            }
            case 16: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.POTATO, random.nextInt(8) + 4));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.BAKED_POTATO, random.nextInt(6) + 3));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.POISONOUS_POTATO, random.nextInt(3) + 1));
                break;
            }
            case 17: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.REDSTONE, random.nextInt(16) + 8));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.REDSTONE_TORCH, random.nextInt(8) + 4));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.REPEATER, random.nextInt(4) + 2));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.COMPARATOR, random.nextInt(2) + 1));
                break;
            }
            case 18: {
                this.spawnFallingBlockWithEffects(level, pos, random);
                break;
            }
            case 19: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.COD_BUCKET));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.COOKED_SALMON, random.nextInt(4) + 2));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.PUFFERFISH));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.FISHING_ROD));
                break;
            }
            case 20: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.BEEF, random.nextInt(4) + 2));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.PORKCHOP, random.nextInt(4) + 2));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.CHICKEN, random.nextInt(4) + 2));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.MUTTON, random.nextInt(4) + 2));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.RABBIT, random.nextInt(4) + 2));
                break;
            }
            case 21: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.BOOK, random.nextInt(10) + 5));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.BOOKSHELF, random.nextInt(5) + 3));
                break;
            }
            case 22: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.POTION, random.nextInt(3) + 2));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.SPLASH_POTION, random.nextInt(2) + 1));
                break;
            }
            case 23: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.PRISMARINE, random.nextInt(8) + 4));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.PRISMARINE_BRICKS, random.nextInt(6) + 3));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.PRISMARINE_SHARD, random.nextInt(5) + 3));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)SimpleLuckyBlockMod.LUCKY_BLOCK_ITEM.get(), 3));
                break;
            }
            case 24: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.SHEEP_SPAWN_EGG, random.nextInt(3) + 2));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.HORSE_SPAWN_EGG, random.nextInt(2) + 1));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.LLAMA_SPAWN_EGG, random.nextInt(3) + 2));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.WOLF_SPAWN_EGG, random.nextInt(2) + 1));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.RABBIT_SPAWN_EGG, random.nextInt(3) + 2));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.CAT_SPAWN_EGG, random.nextInt(2) + 1));
            }
        }
    }

    private void veryLuckyDrops(ServerLevel level, BlockPos pos, RandomSource random) {
        int dropType = random.nextInt(10);
        switch (dropType) {
            case 0: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.NETHERITE_SWORD));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.NETHERITE_PICKAXE));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.NETHERITE_AXE));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.NETHERITE_SHOVEL));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.NETHERITE_HOE));
                break;
            }
            case 1: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.ENCHANTED_GOLDEN_APPLE, 3));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.GOLDEN_CARROT, random.nextInt(16) + 8));
                break;
            }
            case 2: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.ELYTRA));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.FIREWORK_ROCKET, random.nextInt(32) + 16));
                break;
            }
            case 3: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.DRAGON_EGG));
                break;
            }
            case 4: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.BEACON));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.NETHER_STAR, 2));
                break;
            }
            case 5: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.TOTEM_OF_UNDYING, random.nextInt(3) + 1));
                break;
            }
            case 6: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.SHULKER_BOX));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.ENDER_PEARL, random.nextInt(16) + 8));
                break;
            }
            case 7: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.HEART_OF_THE_SEA));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.CONDUIT));
                break;
            }
            case 8: {
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.ENCHANTED_BOOK));
                this.dropItem((Level)level, pos, new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE, random.nextInt(32) + 16));
                break;
            }
            case 9: {
                for (int i = 0; i < 20; ++i) {
                    ItemEntity bottleEntity = new ItemEntity((Level)level, (double)((float)pos.getX() + (random.nextFloat() - 0.5f) * 4.0f), (double)((float)(pos.getY() + 10) + random.nextFloat() * 5.0f), (double)((float)pos.getZ() + (random.nextFloat() - 0.5f) * 4.0f), new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE));
                    bottleEntity.setDeltaMovement((double)((random.nextFloat() - 0.5f) * 0.6f), (double)(random.nextFloat() * 0.8f + 0.4f), (double)((random.nextFloat() - 0.5f) * 0.6f));
                    level.addFreshEntity((Entity)bottleEntity);
                }
                level.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, (double)pos.getX() + 0.5, (double)pos.getY() + 3.0, (double)pos.getZ() + 0.5, 50, 2.0, 2.0, 2.0, 0.3);
            }
        }
        level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.UI_TOAST_CHALLENGE_COMPLETE, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.sendParticles((ParticleOptions)ParticleTypes.TOTEM_OF_UNDYING, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 30, 1.0, 1.0, 1.0, 0.2);
    }

    private void spawnFallingBlockWithEffects(ServerLevel level, BlockPos pos, RandomSource random) {
        Block[] blocks = new Block[]{Blocks.DIAMOND_BLOCK, Blocks.EMERALD_BLOCK, Blocks.GOLD_BLOCK, Blocks.IRON_BLOCK, Blocks.LAPIS_BLOCK};
        Block selectedBlock = blocks[random.nextInt(blocks.length)];
        BlockPos skyPos = pos.above(10 + random.nextInt(10));
        FallingBlockEntity fallingBlock = FallingBlockEntity.fall((Level)level, (BlockPos)skyPos, (BlockState)selectedBlock.defaultBlockState());
        level.addFreshEntity((Entity)fallingBlock);
        if (selectedBlock == Blocks.DIAMOND_BLOCK) {
            level.sendParticles((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, (double)pos.getX() + 0.5, (double)pos.getY() + 2.0, (double)pos.getZ() + 0.5, 50, 2.0, 2.0, 2.0, 0.3);
            level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.BLOCKS, 0.5f, 1.0f);
        } else if (selectedBlock == Blocks.EMERALD_BLOCK) {
            level.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 2.0, (double)pos.getZ() + 0.5, 20, 1.0, 1.0, 1.0, 0.1);
        } else if (selectedBlock == Blocks.GOLD_BLOCK) {
            level.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, (double)pos.getX() + 0.5, (double)pos.getY() + 2.0, (double)pos.getZ() + 0.5, 15, 1.0, 1.0, 1.0, 0.1);
        } else if (selectedBlock == Blocks.IRON_BLOCK) {
            level.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 2.0, (double)pos.getZ() + 0.5, 25, 1.0, 1.0, 1.0, 0.1);
        } else if (selectedBlock == Blocks.LAPIS_BLOCK) {
            level.sendParticles((ParticleOptions)ParticleTypes.SPLASH, (double)pos.getX() + 0.5, (double)pos.getY() + 2.0, (double)pos.getZ() + 0.5, 20, 1.0, 1.0, 1.0, 0.1);
        }
    }

    private void dropItem(Level level, BlockPos pos, ItemStack stack) {
        if (!level.isClientSide() && !stack.isEmpty()) {
            ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, stack);
            RandomSource random = level.random;
            itemEntity.setDeltaMovement((double)((random.nextFloat() - 0.5f) * 0.3f), (double)(random.nextFloat() * 0.5f + 0.2f), (double)((random.nextFloat() - 0.5f) * 0.3f));
            level.addFreshEntity((Entity)itemEntity);
        }
    }
}

