/*
 * Decompiled with CFR 0.152.
 */
package com.simpleluckyblock;

import com.mojang.logging.LogUtils;
import com.simpleluckyblock.LuckyBlock;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="simpleluckyblock")
public class SimpleLuckyBlockMod {
    public static final String MODID = "simpleluckyblock";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"simpleluckyblock");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"simpleluckyblock");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"simpleluckyblock");
    public static final RegistryObject<Block> LUCKY_BLOCK = BLOCKS.register("lucky_block", () -> new LuckyBlock(BlockBehaviour.Properties.of().setId(BLOCKS.key("lucky_block")).mapColor(MapColor.GOLD).strength(0.5f).sound(SoundType.STONE)));
    public static final RegistryObject<BlockItem> LUCKY_BLOCK_ITEM = ITEMS.register("lucky_block", () -> new BlockItem((Block)LUCKY_BLOCK.get(), new Item.Properties().setId(ITEMS.key("lucky_block")).useItemDescriptionPrefix()));
    public static final RegistryObject<CreativeModeTab> SIMPLE_LUCKY_BLOCK_TAB = CREATIVE_MODE_TABS.register("simple_lucky_block", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.COMBAT}).icon(() -> ((BlockItem)LUCKY_BLOCK_ITEM.get()).getDefaultInstance()).title((Component)Component.translatable((String)"itemGroup.simpleluckyblock.simple_lucky_block")).displayItems((parameters, output) -> output.accept((ItemLike)LUCKY_BLOCK_ITEM.get())).build());

    public SimpleLuckyBlockMod(FMLJavaModLoadingContext context) {
        BusGroup modBusGroup = context.getModBusGroup();
        FMLCommonSetupEvent.getBus((BusGroup)modBusGroup).addListener(this::commonSetup);
        BLOCKS.register(modBusGroup);
        ITEMS.register(modBusGroup);
        CREATIVE_MODE_TABS.register(modBusGroup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
    }

    @Mod.EventBusSubscriber(modid="simpleluckyblock", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
        }
    }

    @Mod.EventBusSubscriber(modid="simpleluckyblock")
    public static class ServerModEvents {
        @SubscribeEvent
        public static void onServerStarting(ServerStartingEvent event) {
            LOGGER.info("HELLO from server starting");
        }
    }
}

