/*
 * Decompiled with CFR 0.152.
 */
package com.thanatoros.deactivateriptideflight.mixin;

import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={TridentItem.class})
public abstract class DeactivateRiptideFlightMixin
extends Item {
    public DeactivateRiptideFlightMixin(Item.Properties p_43381_) {
        super(p_43381_);
    }

    public boolean releaseUsing(ItemStack p_43394_, Level p_43395_, LivingEntity p_43396_, int p_43397_) {
        if (p_43396_ instanceof Player) {
            Player player = (Player)p_43396_;
            int i = this.getUseDuration(p_43394_, p_43396_) - p_43397_;
            if (i < 10) {
                return false;
            }
            float f = EnchantmentHelper.getTridentSpinAttackStrength((ItemStack)p_43394_, (LivingEntity)player);
            if (f > 0.0f && !player.isInWaterOrRain()) {
                return false;
            }
            if (p_43394_.nextDamageWillBreak()) {
                return false;
            }
            Holder holder = EnchantmentHelper.pickHighestLevel((ItemStack)p_43394_, (DataComponentType)EnchantmentEffectComponents.TRIDENT_SOUND).orElse(SoundEvents.TRIDENT_THROW);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            if (p_43395_ instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)p_43395_;
                p_43394_.hurtWithoutBreaking(1, player);
                if (f == 0.0f) {
                    ThrownTrident throwntrident = (ThrownTrident)Projectile.spawnProjectileFromRotation(ThrownTrident::new, (ServerLevel)serverlevel, (ItemStack)p_43394_, (LivingEntity)player, (float)0.0f, (float)2.5f, (float)1.0f);
                    if (player.hasInfiniteMaterials()) {
                        throwntrident.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                    } else {
                        player.getInventory().removeItem(p_43394_);
                    }
                    p_43395_.playSound(null, (Entity)throwntrident, (SoundEvent)holder.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    return true;
                }
            }
            if (f > 0.0f) {
                p_43395_.playSound(null, (Entity)player, (SoundEvent)holder.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean isTooDamagedToUse(ItemStack p_344861_) {
        return p_344861_.getDamageValue() >= p_344861_.getMaxDamage() - 1;
    }
}

